#ifndef IIRSCRAM_PACKAGE_DECLARATION_HH
#define IIRSCRAM_PACKAGE_DECLARATION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_PackageDeclaration.hh,v 1.2 1999/03/09 20:55:48 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_PackageDeclaration.hh"

class IIR_Name;

class IIRScram_PackageDeclaration : public IIRBase_PackageDeclaration {

public:
  void _publish_vhdl_decl(ostream &);
  void _publish_vhdl(ostream &);

  void _publish_cc();
  void _publish_cc_header();
  //  void _publish_cc_include_files();
  void _publish_cc_headers();
  void _publish_cc_cc_file();
  void _publish_cc_elaborate();
  void _publish_cc_package_name();
  IIR_Declaration* _get_prefix_declaration();
  IIR_Declaration* _get_package_declaration();

  set<IIR_Declaration> *_find_declarations( IIR_Name * );
  IIR_TypeDefinition *_get_subtype(){ return NULL; }

  declaration_type _get_type();

  IIR_Boolean _is_iir_package_declaration(){ return TRUE; }
  IIR_Boolean _is_primary_unit(){ return TRUE; }

  void _add_to_declarative_region( set<IIR_Declaration> * );
  void _make_interface_visible( symbol_table * );

  void _type_check();

protected:
  IIRScram_PackageDeclaration();
  virtual ~IIRScram_PackageDeclaration() = 0;
    
private:
};
#endif
