// Copyright (c) 1996-1999 The FUNCTIONniversity of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ProcedureDeclaration.cc,v 1.5 1999/03/16 02:34:27 ssubrama Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_ProcedureDeclaration.hh"
#include "IIR_Identifier.hh"
#include "symbol_table.hh"
#include "IIR_StringLiteral.hh"
#include "IIR_InterfaceDeclaration.hh"
#include "IIR_WaitStatement.hh"
#include "IIR_DesignatorExplicit.hh"
#include "IIR_ProcedureCallStatement.hh"
#include "set.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_ProcedureDeclaration::~IIRScram_ProcedureDeclaration() {}

IIRScram_ProcedureReturnTypeDefinition
IIRScram_ProcedureDeclaration::_procedure_return_type;

IIR_TypeDefinition *
IIRScram_ProcedureDeclaration::_get_procedure_return_type(){
  return &_procedure_return_type;
}

void
IIRScram_ProcedureDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << "procedure ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  
  if (interface_declarations.num_elements() != 0) {
    _vhdl_out << "(";
    interface_declarations._publish_vhdl_decl(_vhdl_out);
    _vhdl_out << ")";
  }

  if (_contains_body() == TRUE) {
    _vhdl_out << " is\n";
    if (subprogram_declarations.num_elements() != 0) {
      subprogram_declarations._publish_vhdl_decl(_vhdl_out);
    }
    _vhdl_out << "begin\n";
    subprogram_body._publish_vhdl(_vhdl_out);
    _vhdl_out << "end procedure " << *get_declarator();
  }
  _vhdl_out << ";\n";
}


// Mangling of functions and procedures is done here as a constnat string
// "savant" is added as a suffix to the function name.
//
// This cannot be done at the subprogram level as for functions, the
// return type is added a prefix while for procedures it is not.

void
IIRScram_ProcedureDeclaration::_mangle_declarator() {
  ostrstream newMangledDeclarator;
  IIR_InterfaceDeclaration *interface_element;

  if ((_get_declarative_region() != NULL)  && (_get_declarative_region()->_is_iir_declaration() == TRUE)&& (this->get_kind() != IIR_LIBRARY_DECLARATION))  {
    if ((_get_declarative_region()->_is_textio() == FALSE) && (_get_declarative_region()->_is_standard() == FALSE))  {

      if ((IIR_TextLiteral::_cmp(get_declarator(), "write") != 0) && (IIR_TextLiteral::_cmp(get_declarator(), "read") != 0)) {
	newMangledDeclarator << *_get_declarative_region()->_get_declarator();
	newMangledDeclarator << "_";
	if(interface_declarations.num_elements() >= 1) {
	  interface_element = interface_declarations.first();
	  // newMangledDeclarator << "_";
	  while (interface_element != NULL) {
	    ASSERT(interface_element->_get_subtype() != NULL);
	    if (interface_element->_get_subtype()->_get_declaration() == NULL){
	      if (interface_element->_get_subtype()->_get_bottom_base_type() != NULL &&
		  interface_element->_get_subtype()->_get_bottom_base_type()->_get_declaration() != NULL){
		newMangledDeclarator << *((IIRScram_Declaration *) interface_element->get_subtype()->_get_bottom_base_type()->_get_declaration())->get_declarator();
	      }
	    }
	    else {
	      newMangledDeclarator << *((IIRScram_Declaration*)interface_element->get_subtype()->_get_declaration())->get_declarator();
	    }
	    interface_element = interface_declarations.successor(interface_element);
	  }
	}	
      }
    }
  }
  
  //Mangling with the argument types
  if(get_declarator()->_is_string_literal() == TRUE) {
    ((IIR_StringLiteral*)get_declarator())->_convert_function_name(newMangledDeclarator);
  } else {
    newMangledDeclarator << "savant"
			 << *get_declarator();
  }
  
  newMangledDeclarator << ends;
  _set_mangled_declarator(newMangledDeclarator.str());
}

void
IIRScram_ProcedureDeclaration::_publish_cc() {
  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }

  if(get_declarator()->_is_string_literal()) {
    ((IIR_StringLiteral*)_get_declarator())->_publish_cc_function_name();
  } else {
    // _cc_out << "savant";
    _get_declarator()->_publish_cc();
  }
  // XXX probably need to generate args here, once the call is
  // semantically converted, e.g.:
  //_cc_out << "(";
  //interface_declarations._publish_cc();
  //_cc_out << ")";
}


void 
IIRScram_ProcedureDeclaration::_publish_cc_decl() {
  if(_contains_body() == TRUE) {
    ASSERT(cgen_sym_tab_ptr != NULL);
    IIR_WaitStatement *wait;
    IIR_ProcedureCallStatement *proc;
    symbol_table *saved_cgen_sym_tab_ptr = cgen_sym_tab_ptr;
    // We need a separate symbol table for a procedure statement to keep
    // track of the declarations that must be saved (and restored later)
    // when we execute a wait.  This is maintained in this.  This is
    // accessed in IIRScram_WaitStatement through the "extern"
    // cgen_sym_tab_ptr.
    symbol_table procedure_cgen_sym_tab_ptr( 4093, false );
    
    // Publish the subprograms and types within the declaratiove region of
    // this subprogram, since these need to be published just once.  They
    // should not be published while publishing the type conversion
    // function / resolution function.
    subprogram_declarations._publish_cc_decl_subprograms_and_types();
    
    cgen_sym_tab_ptr = &procedure_cgen_sym_tab_ptr;
    
    // First collect the necessary information regarding the subprogram.
    dl_list<IIR_WaitStatement> _wait_stmt_list;
    subprogram_body._build_wait_list((dl_list<IIRScram_WaitStatement> *) &_wait_stmt_list);
    dl_list<IIR_ProcedureCallStatement> _procedure_stmt_list;
    subprogram_body._build_procedure_call_stmt_list(&_procedure_stmt_list);
    
//     _publish_cc_wait_data(&_wait_stmt_list);
    
    PublishedUnit _saved_publishing_unit = _get_currently_publishing_unit();
    _set_currently_publishing_unit(IIRScram::PROCEDURE);
    
    // Redefine savantnow for a subprogram.
    _publish_cc_redefine_savantnow();
    
    _cc_out << "int ";
    if(get_declarator()->_is_string_literal()) {
      ((IIR_StringLiteral*)_get_declarator())->_publish_cc_function_name();
    }
    else {
      _get_declarator()->_publish_cc();
    }
    _cc_out << "(";
    
    // First argument of the subprogram is always a pointer to the process
    // that invoked it.  This is required since we need to access methods
    // like getTimeNow() and writeline() from the subprogram, but which are
    // methods of a process.
    _cc_out << "VHDLKernelBase *processPtr";
    
    if(interface_declarations.num_elements() != 0) {
      _cc_out << ", ";
      interface_declarations._publish_cc_decl_subprogram_args(FALSE);
    }
  _cc_out << ") {" << endl;

  // Copy the constant params_in to local non-const params
  if (interface_declarations.num_elements() != 0) {
    interface_declarations._publish_cc_local_parameter_args();
  }
  
  // Publish any declarations in this function 
  _publish_cc_declarations();
  _cc_out << endl;
  
  // Necessary statements for wait statement (in procedure) implementation.
  if(_wait_stmt_list.num_elements() > 0) {
    _publish_cc_wait_init(&_wait_stmt_list);
  } // if
  
  _cc_out << "CallStack *callStack = processPtr->getCallStack();" << endl
	  << "if(processPtr->getWaitLabel() == WAITING_IN_PROC) {" << endl
	  << "callStack->setCurrentToNext();" << endl;
  // "goto"s for wait statements in the procedure.
  for (wait = _wait_stmt_list.first(); wait != NULL; 
       wait = _wait_stmt_list.successor(wait))  {
    _cc_out << "  if(callStack->getCurrentTop()->waitLabel == "
	    << wait->wait_id << ") goto ";
    wait->_publish_cc_wait_label();
    _cc_out << ";" << endl;
  } // for
  
  // "goto"s for procedure call statements in the procedure.
  for (proc = _procedure_stmt_list.first(); proc != NULL; 
       proc = _procedure_stmt_list.successor(proc))  {
    _cc_out << "  if(callStack->getCurrentTop()->waitLabel == "
	    << proc << ") goto ";
    proc->_publish_cc_proc_label();
    _cc_out << ";" << endl;
  } // for
  _cc_out << "}" << endl << endl;
  
  // Publish the body of the procedure.
  _set_publish_prefix_string(NULL);
  subprogram_body._publish_cc();

  // Publish implicit file_closes for files in this procedure, if any
  _publish_cc_implicit_file_close();
  
  // We do need a return statement for the procedure since it returns an
  // int, and C++ compiler will crib otherwise.  Moreover, this is
  // required by it's parent to detect the type of return.  If we reach
  // here, it MUST be a normal return.
  _cc_out << "return NORMAL_RETURN;\n" 
	  << "}\n\n";
  
  // Restore the definition of savantnow
  _publish_cc_restore_savantnow();
  
  _copy_symbols_defined_in_enclosing_scope(cgen_sym_tab_ptr, saved_cgen_sym_tab_ptr);
  // Restore the saved symbol table.
  cgen_sym_tab_ptr = saved_cgen_sym_tab_ptr;
  
  _set_currently_publishing_unit(_saved_publishing_unit);
  
  }

}

void
IIRScram_ProcedureDeclaration::_publish_cc_wait_data(dl_list<IIR_WaitStatement> *_wait_stmt_list) {
  IIR_WaitStatement *wait;
  for (wait = _wait_stmt_list->first(); wait != NULL; 
       wait = _wait_stmt_list->successor(wait))  {
    wait->_publish_cc_proc_wait_data();
  }
}

void 
IIRScram_ProcedureDeclaration::_publish_cc_type_info(){
  subprogram_declarations._publish_cc_type_info();
}

void 
IIRScram_ProcedureDeclaration::_publish_cc_extern_type_info(){
  subprogram_declarations._publish_cc_extern_type_info();
}
  
void
IIRScram_ProcedureDeclaration::_publish_cc_wait_init(dl_list<IIR_WaitStatement> *_wait_stmt_list) {
  IIR_WaitStatement *wait;
  IIR_Boolean sens_list_newed = FALSE; // Flag used to indicate that the
				       // new'ed memory should be deleted.

  _cc_out << "static Wait procedureWait[" << _wait_stmt_list->num_elements()
	  << "];" << endl
	  << "if(procedureWait[0].sensSize == -1) {" << endl;
  for (wait = _wait_stmt_list->first(); wait != NULL; 
       wait = _wait_stmt_list->successor(wait))  {
    if (wait->sensitivity_list.num_elements() == 0) { 
      if(wait->get_condition_clause() != NULL) {
	wait->get_condition_clause()->_build_sensitivity_list(&wait->sensitivity_list);
	sens_list_newed = TRUE;
      }
    }

    if (wait->sensitivity_list.num_elements() != 0) {
      _cc_out << "  procedureWait[" << wait->wait_id << "].sensSize = " 
	      << wait->sensitivity_list.num_elements() << ";" << endl
	      << "  procedureWait[" << wait->wait_id << "].sensList = "
	      << "(VHDLType**) new char[sizeof(VHDLType*)*"
	      << wait->sensitivity_list.num_elements() << "];" << endl;
    }
  } // for
  _cc_out << "}" << endl;
  for (wait = _wait_stmt_list->first(); wait != NULL; 
       wait = _wait_stmt_list->successor(wait))  {
    if(wait->sensitivity_list.num_elements() != 0) {
      int sig = 0;
      IIR_Declaration *sens_sig;
      IIR_Designator *current_signal_designator;

      for(current_signal_designator = wait->sensitivity_list.first();
	  current_signal_designator != NULL;
	  current_signal_designator = wait->sensitivity_list.successor(current_signal_designator),sig++) {
	sens_sig = (IIR_Declaration *)((IIR_DesignatorExplicit *)current_signal_designator)->get_name();
	ASSERT(sens_sig->_is_signal() == TRUE);
	ASSERT(sens_sig->_is_iir_declaration() == TRUE);

        _cc_out <<"  procedureWait[" << wait->wait_id << "].sensList[" 
		<< sig << "] = (VHDLType*)&";
	sens_sig->_publish_cc();
	_cc_out << ";" << endl;
      }	// for
      if(sens_list_newed == TRUE) {
	current_signal_designator = wait->sensitivity_list.first();
	while(current_signal_designator != NULL) {
	  IIR_Designator *next =  wait->sensitivity_list.successor(current_signal_designator);
	  wait->sensitivity_list.remove((IIR*) current_signal_designator);
	  delete (IIR_DesignatorExplicit *)current_signal_designator;
	  current_signal_designator = next;
	} // while
      }	// if(sens_list_newed == TRUE)
    } // if
  } // for
}  

void 
IIRScram_ProcedureDeclaration::_get_signal_source_info(set<IIR_Declaration> *siginfo) {
  IIR_InterfaceDeclaration *decl = interface_declarations.first();
  for(; decl != NULL; decl = interface_declarations.successor(decl)) {
    if(decl->get_mode() == IIR_OUT_MODE ||
       decl->get_mode() == IIR_INOUT_MODE) {
      siginfo->add((IIR_Declaration *)decl);
    }
  }
}

IIRScram_Declaration::declaration_type 
IIRScram_ProcedureDeclaration::_get_type(){
   return PROCEDURE;
}


IIR_TypeDefinition *
IIRScram_ProcedureDeclaration::_get_subtype(){
  return &_procedure_return_type;
}

