#ifndef HLIST_HH
#define HLIST_HH

template <class LType> class iterator;
template <class LType> class list;

template <class LType> class listelem {
public:
  friend class iterator<LType>;
  friend class list<LType>;
  listelem(LType data, listelem* n): val(data), next(n) {} 
private:
  LType val;
  listelem *next;
};

template <class LType> class list {
public:
  friend class iterator<LType>;
  list();
  ~list();
  void insert(LType elem);
  bool is_empty();
  void dump_list();
  iterator<LType> begin();
  iterator<LType> end();
private:
  listelem<LType> *head;
  listelem<LType> *tail;
};

template <class LType> class iterator {
public:
  iterator() { ptr = 0; }
  iterator(listelem<LType>* p):ptr(p) {}
  iterator<LType> operator++();
  bool operator==(const iterator &value) { return ptr == value.ptr; }
  bool operator!=(const iterator &value) { return ptr != value.ptr; }
  LType& operator*() { return ptr->val; }
  bool has_more_elements() { return (ptr != 0); }
private:
  listelem<LType> *ptr;
};

#endif


