#include <gtk/gtk.h>

#include "guiinterface.h"

#include "../history.h"

static void _cb_load(GtkWidget *w, GtkWidget *fs)
{
	history_load(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
	gtk_widget_destroy(fs);
}

static void _cb_save(GtkWidget *w, GtkWidget *fs)
{
	history_save(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
	gtk_widget_destroy(fs);
}

void gui_loadgame_dialog_create(GtkWidget **dialog)
{
	*dialog = gtk_file_selection_new("Load Game");
	gtk_signal_connect (GTK_OBJECT(*dialog), "destroy", GTK_SIGNAL_FUNC(cb_dialog_destroy), dialog);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(*dialog)->ok_button), "clicked", GTK_SIGNAL_FUNC(_cb_load), *dialog);
	gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(*dialog)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(*dialog));
	gtk_widget_show(*dialog);
}

void gui_savegame_dialog_create(GtkWidget **dialog)
{
	*dialog = gtk_file_selection_new("Save Game");
	gtk_signal_connect (GTK_OBJECT(*dialog), "destroy", GTK_SIGNAL_FUNC(cb_dialog_destroy), dialog);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(*dialog)->ok_button), "clicked", GTK_SIGNAL_FUNC(_cb_save), *dialog);
	gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(*dialog)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(*dialog));
	gtk_widget_show(*dialog);
}
