/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * This is GNU GO, a Go program. Contact gnugo@gnu.org, or see   *
 * http://www.gnu.org/software/gnugo/ for more information.      *
 *                                                               *
 * Copyright 1999 by the Free Software Foundation.               *
 *                                                               *
 * This program is free software; you can redistribute it and/or *
 * modify it under the terms of the GNU General Public License   *
 * as published by the Free Software Foundation - version 2.     *
 *                                                               *
 * This program is distributed in the hope that it will be       *
 * useful, but WITHOUT ANY WARRANTY; without even the implied    *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR       *
 * PURPOSE.  See the GNU General Public License in file COPYING  *
 * for more details.                                             *
 *                                                               *
 * You should have received a copy of the GNU General Public     *
 * License along with this program; if not, write to the Free    *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,       *
 * Boston, MA 02111, USA                                         *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */






/* Compile the eye database. This produces graphs.c. */

/* see also eyes.db, eyes.c and src/eyes.c */


#define MAX_BOARD 19
#define MAXLINE 80
#define MAXDIMEN 20
#define MAXSIZE 20
#define MAXPATNO 200

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>


#define DEBUG(x)  /* printf x */

int
main(void)
{
  char line[MAXLINE];
  int patno=0;
  int p;
  char vertex[MAXDIMEN][MAXDIMEN];
  int marginal[MAXDIMEN][MAXDIMEN];
  int neighbors[MAXSIZE];
/*
  int neighbors2[MAXSIZE];
  int neighbors3[MAXSIZE];
  int neighbors4[MAXSIZE];
*/
  int k, h;
  int m=0, n=0, l;
  int vi[MAXSIZE], vj[MAXSIZE];
  int esize[MAXPATNO], msize[MAXPATNO];
  int max[MAXPATNO], min[MAXPATNO];
  int ends[MAXPATNO], two_neighbors[MAXPATNO], three_neighbors[MAXPATNO];
  int vital[MAXPATNO];
  int debug=0;
  
  printf("\
/* This file is automatially generated by mkeyes. Do not\n\
 * edit it directly. Instead, edit the eye shape database.\n\
 */\n\n\

#include \"eyes.h\"\n\n");

  memset(ends, 0, sizeof(ends));
  memset(two_neighbors, 0, sizeof(two_neighbors));
  memset(three_neighbors, 0, sizeof(three_neighbors));
  memset(esize, 0, sizeof(esize));
  memset(vital, -1, sizeof(vital));

  while (fgets(line, MAXLINE, stdin)) {
    if (sscanf(line,"Pattern %d", &p)) {
      if (p != patno) {
	fprintf(stderr,"mkeyes: Pattern %d out of sequence\n", p);
	return 1;
      }
      if (debug) fprintf(stderr,"parsing pattern %d\n", patno);
      memset(vertex, 0, sizeof(vertex));
      memset(marginal, 0, sizeof(marginal));
      m=0;
      esize[patno]=0;
      msize[patno]=0;
    }
    else {
      if (strncmp("#",line,1) && strncmp("\n",line,1)) {
	if (strncmp(":",line,1)) {
	  for (n=0; (n<MAXDIMEN) && strncmp("\n",line+n,1); n++) {
	    if (line[n]!=' ') {
	      vi[esize[patno]]=m;
	      vj[esize[patno]]=n;
	      switch (line[n]) 
		{
		case '.':
		  if (debug) fprintf(stderr,".");
		  vertex[m][n]='.';
		  marginal[m][n]=0;
		  break;
		case '!':
		  if (debug) fprintf(stderr,"!");
		  vertex[m][n]='!';
		  msize[patno]++;
		  marginal[m][n]=1;
		  break;
		case '@':
		  if (debug) fprintf(stderr,"@");
		  vertex[m][n]='@';
		  msize[patno]++;
		  marginal[m][n]=1;
		  vital[patno]=esize[patno];
		  break;
		case 'x':
		  if (debug) fprintf(stderr,"x");
		  vertex[m][n]='x';
		  marginal[m][n]=0;
		  break;
		case '*':
		  if (debug) fprintf(stderr,"*");
		  vertex[m][n]='.';
		  marginal[m][n]=0;
		  vital[patno]=esize[patno];
		  break;
		case 'X':
		  vertex[m][n]='X';
		  marginal[m][n]=0;
		if (debug) fprintf(stderr,"X");
		break;
		default:
		  fprintf (stderr, "mkeyes: invalid character %c in pattern\n", line[n]);
		  abort;
		}
	      esize[patno]++;
	    }
	  }
	  m++;
	  if (debug) fprintf(stderr,"\n");
	}
	else {
	  sscanf(line,":%d,%d",&(max[patno]),&(min[patno]));
	  if (debug) fprintf (stderr,"max=%d, min=%d\n",max[patno],min[patno]);
	  printf("static struct eye_vertex 
eye%d[]={\n", patno);
	  for (l=0; l<esize[patno]; l++) {

	    int ni[4];
	    int nj[4];
	    int nb[4];
	    int mx[MAXDIMEN][MAXDIMEN];
	    int count=0;
	    
	    memset(mx, -1, sizeof(mx));

	    neighbors[l]=0;

/*
	    neighbors2[l]=0;
	    neighbors3[l]=0;
    	    neighbors4[l]=0;
*/

	    for (h=0; h<4; h++) {
	      ni[h]=-1;
	      nj[h]=-1;
	      nb[h]=-1;
	    }

	    mx[vi[l]][vj[l]]=0;

	    if ((vi[l]>0) && vertex[vi[l]-1][vj[l]]) {
	      ni[neighbors[l]]=vi[l]-1;
	      nj[neighbors[l]]=vj[l];
	      neighbors[l]++;
	      count++;
	      mx[vi[l]-1][vj[l]]=l;
	    }
	    if ((vi[l]<MAXDIMEN-1) && vertex[vi[l]+1][vj[l]]) {
	      ni[neighbors[l]]=vi[l]+1;
	      nj[neighbors[l]]=vj[l];
	      neighbors[l]++;
	      count++;
	      mx[vi[l]+1][vj[l]]=l;
	    }
	    if ((vj[l]>0) && vertex[vi[l]][vj[l]-1]) {
	      ni[neighbors[l]]=vi[l];
	      nj[neighbors[l]]=vj[l]-1;
	      neighbors[l]++;
	      mx[vi[l]][vj[l]-1]=l;
	    }
	    if ((vi[l]<MAXDIMEN-1) && vertex[vi[l]][vj[l]+1]) {
	      ni[neighbors[l]]=vi[l];
	      nj[neighbors[l]]=vj[l]+1;
	      neighbors[l]++;
	      mx[vi[l]][vj[l]+1]=l;
	    }

/*

	    for (h=0; h<esize[patno]; h++) {
	      if (mx[vi[h]][vj[h]] == -1) {
		if ((vi[h]>0) && (mx[vi[h]-1][vj[h]]<2) && (mx[vi[h]-1][vj[h]] != -1)) {
		  (neighbors2[l])++;
		  mx[vi[h]][vj[h]]=2;
		}
		else if ((vi[h]<MAXDIMEN-1) && (mx[vi[h]+1][vj[h]]<2) && (mx[vi[h]+1][vj[h]] != -1)) {
		  mx[vi[h]][vj[h]]=2;
		  (neighbors2[l])++;
		}
		else if ((vi[h]>0) && (mx[vi[h]][vj[h]-1]<2) && (mx[vi[h]][vj[h]-1] != -1)) {
		  mx[vi[h]][vj[h]]=2;
		  (neighbors2[l])++;
		}
		else if ((vi[h]<MAXDIMEN-1) && (mx[vi[h]][vj[h]+1]<2) && (mx[vi[h]][vj[h]+1] != -1)) {
		  mx[vi[h]][vj[h]]=2;
		  (neighbors2[l])++;
		}
	      }
	    }
	    for (h=0; h<esize[patno]; h++) {
	      if (mx[vi[h]][vj[h]] == -1) {
		if ((vi[h]>0) && (mx[vi[h]-1][vj[h]]<3) && (mx[vi[h]-1][vj[h]] != -1)) {
		  mx[vi[h]][vj[h]]=3;
		  neighbors3[l]++;
		}
		else if ((vi[h]<MAXDIMEN-1) && (mx[vi[h]+1][vj[h]]<3) && (mx[vi[h]+1][vj[h]] != -1)) {
		  mx[vi[h]][vj[h]]=3;
		  neighbors3[l]++;
		}
		else if ((vi[h]>0) && (mx[vi[h]][vj[h]-1]<3) && (mx[vi[h]][vj[h]-1] != -1)) {
		  mx[vi[h]][vj[h]]=1;
		  neighbors3[l]++;
		}
		else if ((vi[h]<MAXDIMEN-1) && (mx[vi[h]][vj[h]+1]<3) && (mx[vi[h]][vj[h]+1] != -1)) {
		  mx[vi[h]][vj[h]]=1;
		  neighbors3[l]++;
		}
	      }
	    }
	    for (h=0; h<esize[patno]; h++) {
	      if (mx[vi[h]][vj[h]] == -1) {
		if ((vi[h]>0) && (mx[vi[h]-1][vj[h]]<4) && (mx[vi[h]-1][vj[h]] != -1)) {
		  mx[vi[h]][vj[h]]=4;
		  neighbors4[l]++;
		}
		else if ((vi[h]<MAXDIMEN-1) && (mx[vi[h]+1][vj[h]]<4) && (mx[vi[h]+1][vj[h]] != -1)) {
		  mx[vi[h]][vj[h]]=4;
		  neighbors4[l]++;
		}
		else if ((vi[h]>0) && (mx[vi[h]][vj[h]-1]<4) && (mx[vi[h]][vj[h]-1] != -1)) {
		  mx[vi[h]][vj[h]]=1;
		  neighbors4[l]++;
		}
		else if ((vi[h]<MAXDIMEN-1) && (mx[vi[h]][vj[h]+1]<4) && (mx[vi[h]][vj[h]+1] != -1)) {
		  mx[vi[h]][vj[h]]=1;
		  neighbors4[l]++;
		}
	      }
	    }

*/

	    if (neighbors[l]==1)
	      ends[patno]++;
	    else if (neighbors[l]==2)
	      two_neighbors[patno]++;
	    else if (neighbors[l]==3)
	      three_neighbors[patno]++;

	    for (h=0; h<esize[patno]; h++) {

	      for (k=0; k<4; k++)
		if ((ni[k] != -1) && (vi[h]==ni[k]) && (vj[h]==nj[k]))
		  nb[k]=h;
	    }


	    printf("   {%d, %d, \'%c\', %d, %d, %d, %d, %d}",
		   vi[l], vj[l], vertex[vi[l]][vj[l]], 
		   neighbors[l], nb[0], nb[1], nb[2], nb[3]);
	    if (l<esize[patno]-1)
	      printf(",\n");
	    else
	      printf("\n};\n\n");
	  }
	  patno++;
	}
      }
    }
  }

  
  printf("\nstruct eye_graph graphs[]={\n");
  for (l=0; l < patno; l++) {

    printf("   {eye%d, %d, %d, %d, %d, %d, %d, %d, %d}",
	   l, esize[l], msize[l], ends[l], two_neighbors[l], three_neighbors[l], 
	   max[l], min[l], vital[l]);
    if (l<patno-1)
      printf(",\n");
    else
      printf("\n};\n\n#define GRAPHS %d\n", patno);
  }
  return 0;
}

/*
 * Local Variables:
 * tab-width: 8
 * c-basic-offset: 2
 * End:
 */
