/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "files.h"
#include "fonts.h"
#include "../gl/Font.h"
#include "../util/debug.h"

class Font* menuFont = NULL;
class Font* casualFont = NULL;

bool loadFonts()
{
 nonFatal("loading fonts\n");

 menuFont = new Font;
 casualFont = new Font;

 if(!menuFont->load(libFileName("fonts/menu.ttf"), 20)) goto err;
 if(!casualFont->load(libFileName("fonts/casual.ttf"), 14)) goto err;

 return true;

 err:
 killFonts();
 return false;
}

void killFonts()
{
 if(menuFont) delete menuFont; menuFont = NULL;
 if(casualFont) delete casualFont; casualFont = NULL;
}
