/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _GUI_COLORMAP_BANDS_H
#define _GUI_COLORMAP_BANDS_H

#include <gtk--.h>
#include <gtk/gtk.h>

#include "GuiColormap.h"


/*
 *  GuiColormapBands: build a colormap consisting of a series color bands
 */
class GuiColormapBands : public GuiColormap
	{
	public:
				GuiColormapBands (Gtk_Widget *parent, int numBands, int colsPerBand, int landBandOffset=0);
				~GuiColormapBands ();
		GdkColor	*getBandColor (int band, int color, bool observe_offset=FALSE);
		int		getNumBands ();
		int		getBandSize ();
		int		getLandBandOffset ();
		int		setLandBandOffset (int bandLandOffset);
		bool		allocColorBand (char *colname, float ambient);
		int		allocColorBands (char *colorNames[], float ambient=0.6);


	private:
		int			d_bandsize;
		int			d_nbands;
		int			d_bandLandOffset;
	};


#endif // _GUI_COLORMAP_BANDS_H
