/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef GUI_DIALOG_ABOUT_DISSOLVE_H_
#define GUI_DIALOG_ABOUT_DISSOLVE_H_

#include "GuiDialogAbout.h"				// include gtk, gtk--
#include "GuiBufferedDrawingArea.h"
#include <gdk/gdk.h>
#include <gdk--.h>

#ifndef HAVE_IMLIB
ERROR: You have select an impossible compile option. GuiDialogAboutDissolve
only makes sense if you have imlib to read the JPG picture file.
#endif

#include <gdk_imlib.h>



class GuiDialogAboutDissolve : public GuiDialogAbout
	{
	public: 
				GuiDialogAboutDissolve (char *winTitle, char *imageFile, 
							char **msgPtrs, int nMesgs);
				~GuiDialogAboutDissolve (); 
		void		buildDialogWindow ();
		int		logoTimer ();	
		gint		handleExposeEvent (GdkEventExpose *e);

	protected:
		GuiBufferedDrawingArea	*p_drawArea;
		GdkPixmap		*p_pixmap;
		guchar			*p_dissolveMap;
		int 			d_dissolveWidth, d_dissolveHeight,
					d_animSize, d_animSteps,
					d_animFrame;
	};


#endif // GUI_DIALOG_ABOUT_DISSOLVE_H_
