/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_DIALOG_FILL_H
#define _TF_DIALOG_FILL_H 1


#include "TFPreviewDialog.h"			// includes gtk, gtk--


/*
 *  TFDialogFill: display the filling dialog for terraformer
 */
class TFDialogFill : public TFPreviewDialog
	{
	public: 
				TFDialogFill (HeightField *HF, HeightFieldDraw *HFD);
				~TFDialogFill (); 
		void		buildDialogWindow ();
		void 		buttonCallbackApply ();

	private:
		void		insertOptions ();
		void		updatePreviewCallback ();

		Gtk_VBox		d_vBoxOptions; 
		Gtk_HBox		d_hBoxFillElv, 
					d_hBoxTightFactor,
					d_hBoxKeepMin; 
		Gtk_Adjustment		d_adjFillElv,
					d_adjTightFactor;
		Gtk_HScale 		d_hsFillElv,
					d_hsTightFactor;
		Gtk_Label		d_lblFillElv,
					d_lblTightFactor,
					d_lblKeepMin;
		Gtk_Frame		d_frmOptions;
		Gtk_CheckButton		d_cbKeepMin;
	};


#endif // _TF_DIALOG_FILL_H
