/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFDialogFlowmap.h"
#include "GlobalDefs.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"
#include "TFGui.h"			
#include "TFWindowHandler.h"		// circular depency !


/*
 *  constructor: initialize all data members 
 */
TFDialogFlowmap::TFDialogFlowmap (HeightField *HF, HeightFieldDraw *HFD)
	        : TFBaseDialog (HF, HFD, "Terraform Flowmap Dialog", 
				"Flowmap Type")
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFDialogFlowmap\n");

	p_RB1 = p_RB2 = NULL;
	p_CB = NULL;
	p_group = NULL;
	this->setHFobjs (HF, HFD);
	sprintf (this->p_windowTitle, _("Flowmap: %s"), p_HF->getName());
	buildDialogWindow ();
}


/*
 *  destructor: clean up 
 */
TFDialogFlowmap::~TFDialogFlowmap ()
{
	if (p_RB1) delete p_RB1;
	if (p_RB2) delete p_RB2;
	if (p_CB) delete p_CB;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFDialogFlowmap\n");
}


/*
 *  fillVBox: fill the dialog's VBox
 */
void TFDialogFlowmap::fillVBox ()
{
	SanityCheck::bailout ((!this->p_frmBase), "TFDialogFlowmap called without Frame label", 
		"TFDialogFlowmap::setHFobjs");

	p_RB1 = new Gtk_RadioButton ((GSList *)NULL, _("Single Flow Direction"));
	p_RB1->set_active (TRUE);
	this->d_vbOptions.pack_start (*p_RB1, TRUE, TRUE, s_VBOff);
	p_RB1->show ();

	p_group = p_RB1->group ();
	p_RB2 = new Gtk_RadioButton (p_group, _("Multiple Flow Direction"));
	this->d_vbOptions.pack_start (*p_RB2, TRUE, TRUE, s_VBOff);
	p_RB2->show ();

	this->p_frmBase->add (this->d_vbOptions);

	p_CB = new Gtk_CheckButton (_("Observe Sealevel"));
	p_CB->set_active (FALSE);
	this->get_vbox()->pack_start (*p_CB, TRUE, TRUE, s_VBOff);
	p_CB->show ();

	this->d_vbOptions.show ();
	this->p_frmBase->show ();
	this->get_vbox()->show ();
}


/*
 *  buildDialogWindow:
 */
void TFDialogFlowmap::buildDialogWindow ()
{
	this->set_usize (200, 150);
	this->set_title (this->p_windowTitle);

	this->get_vbox()->set_border_width (2);

	this->setupVBox ();
	fillVBox ();
	fillActionArea ();

	this->show ();
}


/*
 *  buttonCallbackApply: rotate the Height Field
 */
void TFDialogFlowmap::buttonCallbackApply ()
{
	SanityCheck::bailout ((!p_HFO), "p_HFO==NULL", "TFDialogFlowmap::buttonCallbackApply");
	HeightField	*HFF=NULL;

	if (p_RB1->get_active())
		HFF = p_HFO->flowmap (TRUE, !p_CB->get_active());
	else
	if (p_RB2->get_active())
		HFF = p_HFO->flowmap (FALSE, !p_CB->get_active());

	TFGui::addHeightField (HFF);
		
	this->b_applyHit = TRUE;
}


