/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_DIALOG_OPTIONS_H
#define _TF_DIALOG_OPTIONS_H 1


#include "flexarray.h"
#include "GuiDialogOAC.h"				// includes gtk, gtk--



/*
 *  TFDialogOptions: display the options dialog for terraform. This is a 
 * 	global dialog!
 */
class TFDialogOptions : public GuiDialogOAC
	{
	public:	
				TFDialogOptions (FlexArray *wList);
				~TFDialogOptions ();
		void		updateSliders ();
		void		buildDialogWindow ();
		void 		buttonCallbackOK ();
		void 		buttonCallbackApply ();
		gint 		delete_event_impl (GdkEventAny *);

	protected:
		void		buildDrawOptionsFrame ();
		void		buildHFDrawOptionsFrame ();
		void		buildFastWireOptionsFrame ();
		void		buildPOVOptionsFrame ();

	private:
		void		fillVBox ();
		void		getValues (bool *fillSea, bool *drawDerived, 
					int *scale, int *syncRate, 
					int *resolution, float *yscale, 
					float *sealevel, bool *fastHalfRes, 
					bool *fastHalfYscale, bool *fastZrot);

		// had to make alloc of HBox and VBox dynamic to avoid running
		// into the huge-objects warning with egcs
		FlexArray		*d_wList;
		Gtk_Notebook		d_notebook;	
		Gtk_Frame 		d_frame1, d_frame2, d_frame3, d_frame4;
		Gtk_Entry		d_enPOVfile;
		Gtk_CheckButton		d_cbFillSea,
					d_cbDrawDerived,
					d_cbFastResolution,
					d_cbFastYscale,
					d_cbFastZrot,
					d_cbPOVhalfYscale,
					d_cbPOVkeepFiles;
		Gtk_VBox		*p_vb1, *p_vb2, *p_vb3, *p_vb4;
		Gtk_HBox		*p_hb1_1, *p_hb1_2, *p_hb1_3, *p_hb1_4,
					*p_hb2_1, *p_hb2_2, *p_hb2_3,
					*p_hb3_1, *p_hb3_2, *p_hb3_3,
					*p_hb4_1, *p_hb4_2, *p_hb4_3, *p_hb4_4;
		Gtk_Label 		*p_lblTitle1, *p_lblTitle2, 
					*p_lblTitle3, *p_lblTitle4,
					*p_lblScale, *p_lblSync,
					*p_lblResolution, *p_lblYScale, *p_lblSealevel,
					*p_lblFillSea, *p_lblDrawDerived, 
					*p_lblFastResolution, 
					*p_lblFastYscale, *p_lblFastZrot, 
					*p_lblPOVfileName, *p_lblPOVwidth, 
					*p_lblPOVyscale, *p_lblPOVkeepFiles;
		Gtk_Adjustment		*p_adjScale, *p_adjSync,
					*p_adjResolution, *p_adjYScale, *p_adjSealevel,
					*p_adjPOVwidth;
		Gtk_HScale		*p_hsScale, *p_hsSync,
					*p_hsResolution, *p_hsYScale, *p_hsSealevel,
					*p_hsPOVwidth; 
	};

#endif // _TF_DIALOG_OPTIONS_H
