/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_OPTIONS_H
#define _TF_OPTIONS_H 1


#include "HeightField.h"
#include "TFOptionsTable.h"
#include "flexarray.h"


/*
 *  TFOptions: global (static) config values for terraform
 */
class TFOptions : TFOptionsTable
	{
	public: 
		void		processArgs (HeightField **HF, int argc, char **argv);
		void		processGlobalArgs (int argc, char **argv);
		void		processAppArgs (HeightField **HF, int argc, char **argv);
		void		processRCFile ();
		void		updateTFOptions (TFOptionsTable *optTbl);
		void		install ();
		void		helpRCFile ();
		void		updateOptionTable ();
		static void	help ();

		// these variables can be set through the resource file or 
		// the TFDialogOptions dialog and are set in TFOptionsTable
		// they are global for the entire application
		static bool	s_fillSea,		// is sea filled
				s_drawDerivedData,	// do we draw CL or not
				s_fastHalfRes, 		// half resolution for fast wireframe
				s_fastHalfYscale,	// half yscale for fast wireframe
				s_fastZrot,		// enable z-rotation for fast wireframe
				s_POVhalfYscale,	// do we half the y scale when rendering in POV
				s_POVkeepFiles;		// do we keep files or use /tmp
		static int	s_scale, 		// display scale
				s_syncRate,		// DrawingArea sync rate
				s_resolution,		// Wire grid resolution
				s_POVwidth;		// width of POV render
		static float	s_yscale, 		// specify yscale 
				s_sealevel;		// specify sealevel 
		static char 	*s_POVfile;
		

		// these variables can only be set through the command line 
		// and are not part of the TFOptionsTable setup
		static bool	s_large;		// should we make extra large sliders?
		static bool	s_POV30;		// is povray version 3.0? (default = 3.1)
		static char	*s_POVexec;		// the name of your povray executable 
		static bool	s_fixedMenus;		// should HF menu be fixed in a menubar?
		static bool	s_saveSettings;		// if TRUE(=default) we save the settings upon exit


		// variables used to keep treck of things 
		static bool	s_settingsAreChanged;
	};


#endif // _TF_OPTIONS_H
