// dxifile.h
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef _DXIFILE_H_
#define _DXIFILE_H_

#include "qsodata.h"
#include "qsofile.h"
#include "ctyfile.h"

#define MAX_DXI_LINE_SIZE     80
#define MAX_TR_CALL_SIZE      12

class RDxiFile : public RQsoFile {
private:
    RCtyFile *ctyFile;

public:
    RDxiFile()                              { location = 0; };
    RDxiFile(char *name);
#ifdef LINUX
    virtual boolean open(char *name, int mode = ios::in);
#else
    virtual boolean open(char *name, int mode = ios::in | ios::binary);
#endif
    virtual header_data headerInfo()       { return header; };
    virtual boolean nextQso(qso_data *);     /* Return next generic QSO record */
    boolean writeHeader(header_data);
    void storeHeader(header_data);
//    boolean writePageHeader(header_data, qso_data *);
    virtual boolean writeQso(qso_data *);  /* Write next generic QSO record */
};
#endif
