#include <termios.h>
#include <fcntl.h>
#include <stdlib.h>
#include "afos.h"

typedef struct _AFOS_PORT_DATA_ {
	int fd ;
	int outfd ;
	int debug ;
	int rxbytes ;
	int badread ;
	}  AFOS_PORT_DATA ;

AFOS_PORT_DATA aprs_data ;
AFOS_PORT_DATA tnc_data ;


static void
aprs_process_char( void *private, int event )
{
	int rdat = 0;
	int i ;
	int ret ;
	int rfd ;
	AFOS_PORT_DATA *s ;

	s = private ;
	rfd = s->fd ;

	ret = read (rfd, &rdat, 1 );

	if (ret != 1 )
	{
		s->badread++ ;
		return ;
	}
	s->rxbytes++ ;

	if (s->debug & AFOS_PORT_TRACE_BYTE )
		printf("%c", s->fd,  0xff & rdat ) ;

	printf("%d:(%02x)\n",s->fd, 0xff & rdat ) ;

	write ( s->outfd, &rdat, 1 ) ;

	return ;
}

main()
{
	struct termios tparms;
	int parm;
	int ret ;
        int tncfd ;
        int aprsfd ;
	int	dat;


	printf("APRS LOOP Test\n");

	tncfd = open ("/dev/ttyS1", O_RDWR) ;
	aprsfd = open ("/dev/ttyS0", O_RDWR) ;

	if (tncfd < 0 )
	{
		perror ("aprstest unable to open TNC channel's serial port");
		exit(-1);
	}


	if (aprsfd < 0 )
	{
		perror ("aprstest unable to open APRS channel's serial port");
		exit(-1);
	}


	ret = tcgetattr(tncfd, &tparms);
	if ( ret == -1 )
	  {
	    perror("unable to get attributes of TNC port");
	    return -1 ;
	  }

	tparms.c_iflag = IGNBRK | IGNPAR ;
	tparms.c_oflag = 0 ;
	tparms.c_cflag = CS8 | CREAD | CLOCAL ;
	tparms.c_lflag = 0 ;
	cfsetospeed ( &tparms, B9600 ) ;
	cfsetispeed ( &tparms, B9600 ) ;
	ret = tcsetattr(tncfd,TCSANOW,&tparms);
	if (ret == -1)
	{
		perror("Unable to ioctl the TNC port");
		return -1 ;
	}

	ret = tcgetattr(aprsfd, &tparms);
	if ( ret == -1 )
	  {
	    perror("Unable to get attributes on aprs port");
		return -1 ;
	  }

	tparms.c_iflag = IGNBRK | IGNPAR ;
	tparms.c_oflag = 0 ;
	tparms.c_cflag = CS8 | CREAD | CLOCAL ;
	tparms.c_lflag = 0 ;
	cfsetospeed ( &tparms, B9600 ) ;
	cfsetispeed ( &tparms, B9600 ) ;
	ret = tcsetattr(aprsfd,TCSANOW,&tparms);
	if (ret == -1)
	{
		perror("Unable to ioctl the TNC port");
		return -1 ;
	}

	tnc_data.fd = tncfd ;
	tnc_data.outfd = aprsfd ;
	aprs_data.fd = aprsfd ;
	aprs_data.outfd = tncfd ;
	/*
	aprs_data.debug = 0xff ;
	tnc_data.debug = 0xff ;
	*/
	afloop_select_list_add( aprsfd, aprs_process_char, &aprs_data ) ;
	afloop_select_list_add( tncfd, aprs_process_char, &tnc_data ) ;

	
	afloop();
#if 0
	while ( 1) 
	{
		read ( afosfd, &dat, 1 ) ;
		printf ("%c", 0x7f & dat);
	}
#endif
}
