# ----------------------------------------------------------------------------
# - rule.mak                                                                 -
# - acme generic rule definitions                                            -
# ----------------------------------------------------------------------------
# - This program is  free software;  you can  redistribute it and/or  modify -
# - it provided that this copyright notice is kept intact.                   -
# -                                                                          -
# - This  program  is  distributed in the hope  that it  will be useful, but -
# - without  any   warranty;  without  even   the   implied    warranty   of -
# - merchantability  or fitness for a particular purpose. In not event shall -
# - the copyright holder be  liable for  any direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.      -
# ----------------------------------------------------------------------------
# - copyright (c) 1999-2000 amaury darsch                                    -
# ----------------------------------------------------------------------------

ifeq ($(MODE),debug)
  CPPFLAGS	= $(STDCCFLAGS) $(MCHCCFLAGS) $(CPPCCFLAGS) $(DEBUGFLAGS)
  CXXFLAGS	= $(STDCCFLAGS) $(MCHCCFLAGS) $(CXXCCFLAGS) $(DEBUGFLAGS)
  CCDEFINE	= $(STDDEFINES) $(DBGDEFINES)
endif

ifeq ($(MODE),optimized)
  CPPFLAGS	= $(STDCCFLAGS) $(MCHCCFLAGS) $(CPPCCFLAGS) $(OPTCCFLAGS)
  CXXFLAGS	= $(STDCCFLAGS) $(MCHCCFLAGS) $(CXXCCFLAGS) $(OPTCCFLAGS)
  CCDEFINE	= $(STDDEFINES) $(OPTDEFINES)
endif

ifeq ($(MODE),profiled)
  CPPFLAGS      = $(STDCCFLAGS) $(CPPCCFLAGS) $(PFLCCFLAGS)
  CXXFLAGS      = $(STDCCFLAGS) $(CXXCCFLAGS) $(PFLCCFLAGS)
  CCDEFINE      = $(STDDEFINES) $(OPTDEFINES)
endif

PPFLAGS		= $(CPPFLAGS)   $(EXTCPPFLAGS)
XXFLAGS		= $(CXXFLAGS)   $(EXTCXXFLAGS)
DEFINES		= $(CCDEFINE)   $(EXTCCDEFINE)

CPPOBJS		= $(CPPSRCS:.cpp=.o)
CXXOBJS		= $(CXXSRCS:.cxx=.o)
OBJECTS		= $(CPPOBJS) $(CXXOBJS)

# ----------------------------------------------------------------------------
# - compilation rules                                                        -
# ----------------------------------------------------------------------------

-include *.d

%.o : %.cpp 
	$(CC) $(PPFLAGS) $(DEFINES) $(INCLUDE) -o $@ -c $<

%.o : %.cxx 
	$(CC) $(XXFLAGS) $(DEFINES) $(INCLUDE) -o $@ -c $<

# ----------------------------------------------------------------------------
# - dynamic linking and soname rules                                         -
# ----------------------------------------------------------------------------

$(SOLIB): $(SOLIB).$(SONAME)
	@$(MKDIR) $(LIBREL)
	@$(RM) $(LIBREL)/$@
	@$(RM) $@
	@$(LN) $< $(LIBREL)/$@
	@$(LN) $< $@

$(SOLIB).$(SONAME): $(SOLIB).$(SOFILE)
	@$(MKDIR) $(LIBREL)
	@$(RM) $(LIBREL)/$@
	@$(RM) $@
	@$(LN) $< $(LIBREL)/$@
	@$(LN) $< $@

installlib: $(ARLIB) $(SOLIB)
	@$(MKDIR)                   $(LIBDIR)
	@$(RM)                      $(LIBDIR)/$(SOLIB)
	@$(RM)                      $(LIBDIR)/$(SOLIB).$(SONAME)
	@$(CP) $(ARLIB)             $(LIBDIR)
	@$(CP) $(SOLIB).$(SOFILE)   $(LIBDIR)
	@$(LN) $(SOLIB).$(SOFILE)   $(LIBDIR)/$(SOLIB).$(SONAME)
	@$(LN) $(SOLIB).$(SONAME)   $(LIBDIR)/$(SOLIB)
.PHONY: installib

# ----------------------------------------------------------------------------
# - generic unix clean                                                       -
# ----------------------------------------------------------------------------

clean::
	@$(RM) *.o *.d *~ core *.so *.so.* *.a
.PHONY: clean
