// ---------------------------------------------------------------------------
// - Main.cpp                                                                -
// - the aleph interpreter main program                                      -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Interp.hpp"
#include "Options.hpp"

// main interpreter 

int main (int argc, char** argv) {
  using namespace aleph;

  // create a new option instance
  Options* options = new Options (argc,argv);

  // create a new interpreter
  Interp* interp = new Interp;
  Object::iref (interp);

  // set some interpreter flags
  interp->setassert (options->getassert ());
  interp->setargs   (options->getargs   ());

  // loop or execute on the standard input or a file
  String fname = options->getfname ();
  bool status  = (fname.length () == 0) ? interp->loop () : 
                                          interp->loop (fname); 

  // clean eveything and return
  delete options;
  Object::dref (interp);
  return status ? 0 : 1;
}
