// ---------------------------------------------------------------------------
// - Options.hpp                                                             -
// - aleph interpreter - options class definitions                           -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef ALEPH_OPTIONS_HPP
#define ALEPH_OPTIONS_HPP

#ifndef  ALEPH_STRVEC_HPP
#include "Strvec.hpp"
#endif

namespace aleph {

  /// The Options class is the class used by the aleph clients to parse and 
  /// and store user options. The options are later used by the aleph engine.
  /// @author amaury darsch

  class Options {
  private:
    /// the argument list
    Strvec d_argv;
    /// the optional file name
    String d_fname;
    /// the assert flag
    bool d_assert;

  public:
    /// Create a new option class from the main arguments
    /// @param argc the number of arguments
    /// @param argv the argument array
    Options (int argc, char** argv);

    ~Options (void) {
    }

    /// @return the string vector of arguments
    inline const Strvec& getargs (void) const {
      return d_argv;
    }

    /// @return the assert flag
    inline bool getassert (void) const {
      return d_assert;
    }

    /// @return the optional file name
    inline String getfname (void) const {
      return d_fname;
    }

  private:
    // make the copy constructor private
    Options (const Options&);
    // make the assignment operator private
    Options& operator = (const Options&);
  };
}

#endif
