// ---------------------------------------------------------------------------
// - Syscalls.cpp                                                            -
// - aleph:sys library - system call implementation                          -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Vector.hpp"
#include "System.hpp"
#include "Exception.hpp"
 
namespace aleph {

  // exit this process with an exit code

  Object* asys_exit (Interp* interp, Nameset* nset, Cons* args) {
    // get the arguments
    Vector* argv = Vector::eval (interp, nset, args);
    long    argc = (argv == nilp) ? 0 : argv->length ();
    if (argc != 1) throw Exception ("argument-error", 
				    "invalid number of arguments with exit");
    long val = argv->getint (0);
    delete argv;
    System::exit (val);
    return nilp;
  }

  // pause for a certain time

  Object* asys_sleep (Interp* interp, Nameset* nset, Cons* args) {
    // get the arguments
    Vector* argv = Vector::eval (interp, nset, args);
    long    argc = (argv == nilp) ? 0 : argv->length ();
    if (argc != 1) throw Exception ("argument-error", 
				    "invalid number of arguments with sleep");
    long val = argv->getint (0);
    delete argv;
    System::sleep (val);
    return nilp;
  }
}
