// ---------------------------------------------------------------------------
// - InputString.cpp                                                         -
// - standard object library - string stream class implementation            -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "InputString.hpp"

namespace aleph {

  // create an empty string stream

  InputString::InputString (void)  {
    d_buffer.reset ();
  }

  // create a string stream with a buffer

  InputString::InputString (const String& data)  {
    d_buffer.reset    ();
    d_buffer.pushback (data);
  }

  // return the class name

  String InputString::repr (void) const {
    return "InputString";
  }

  // read one byte from the input stream.

  char InputString::read (void) {
    if (d_buffer.length () == 0) return eofc;
    return d_buffer.read ();
  }

  // return true if we are at the eof

  bool InputString::iseof (void) const {
    if (d_buffer.length () == 0) return true;
    return false;
  }

  // set the stream with a string, reset the input buffer
  void InputString::set (const String& line) {
    d_buffer.reset    ();
    d_buffer.pushback (line);
  }
}
