// ---------------------------------------------------------------------------
// - Method.hpp                                                              -
// - standard object library - generic method class definition               -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_METHOD_HPP
#define  ALEPH_METHOD_HPP

#ifndef  ALEPH_STRING_HPP
#include "String.hpp"
#endif

namespace aleph {

  /// The Method class is a generic class which holds an object and a method
  /// name. When the object method is applied, the method call the apply method
  /// by name. This class is a convenient mechanism to hold a pointer to a 
  /// method in a generic way. A call can also be made by quark, that is a
  /// long id instead of a name.
  /// @author amaury darsch

  class Method : public Object {
  private:
    enum {NAMED, QUARK, OBJECT} d_type;
    /// the object instance
    Object* p_object;
    /// the method name
    String  d_name;
    /// the method quark
    long    d_quark;
    /// the method object
    Object* p_method;

  public:
    /// create a new method with a name and an object
    /// @param name   the method name
    /// @param object the calling object
    Method (const String& name, Object* object);

    /// create a new method with a quark and an object
    /// @param quark  the method quark
    /// @param object the calling object
    Method (const long quark, Object* object);

    /// create a new method with a method object
    /// @param method the method object
    /// @param object the calling object
    Method (Object* method, Object* object);

    /// destroy this method instance
    ~Method (void);

    /// @return this class name
    String repr (void) const;

    /// apply this method with a set of arguments
    /// @param interp the current interpreter
    /// @param nset   the current nameset
    /// @param args   the arguments to apply
    Object* apply (Interp* interp, Nameset* nset, Cons* args);

  private:
    // make the copy constructor private
    Method (const Method&);
    // make the assignment operator private
    Method& operator = (const Method&);
  };
}

#endif
