// ---------------------------------------------------------------------------
// - System.cpp                                                              -
// - standard object library - system function class implementation          -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "cio.hxx"
#include "csys.hxx"
#include "cstring.hxx"
#include "System.hpp"
#include "Version.hpp"

namespace aleph {

  // return the option separator

  char System::optsep (void) {
    return c_optsep ();
  }

  // return the os name
  
  String System::osname (void) {
    return String (c_osname ());
  }
  
  // return the version of the aleph system
  
  String System::version (void) {
    return ALEPH_VERSION_FULL;
  }
  
  // exit unconditionally with a status code
  
  void System::exit (int status) {
    c_exit (status);
  }

  // pause for a certain time

  void System::sleep (const long time) {
    c_sleep (time);
  }

  // remove the file name extension
  
  String System::rmext (const String& name) {
    char* fname = name.toChar ();
    char* data  = c_rmext (fname);
    String result = data;
    delete [] fname;
    delete [] data;
    return result;
  }
  
  // return true if the name corresponds to a regular file name
  
  bool System::isfile (const String& name) {
    char* fname = name.toChar ();
    bool status = c_isfile (fname);
    delete [] fname;
    return status;
  }
  
  // return true if the name corresponds to a directory name
  
  bool System::isdir (const String& name) {
    char* dname = name.toChar ();
    bool status = c_isdir (dname);
    delete [] dname;
    return status;
  }
  
  // join two names to form a new file name
  
  String System::join (const String& dir, const String& name) {
    String result = dir + c_dirsep () + name;
    return result;
  }
  
  // execute a command in another process
  
  bool System::system (const String& cmd) {
    char* line  = cmd.toChar ();
    bool status =  c_system (line);
    delete [] line;
    return status;
  }
}
