// ---------------------------------------------------------------------------
// - cmem.hxx                                                                -
// - standard system library - c low level memory function definitions       -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

/// This package contains low level c memory allocation functions. The memory
/// is allocated here by pages and can be relocated quite efficently. If you
/// are familiar with mmap, here it is.
/// @author amaury darsch

#ifndef ALEPH_CMEM_HXX
#define ALEPH_CMEM_HXX

namespace aleph {

  /// @return the system page size
  long c_pagesize (void);

  /// allocate some memory. the memory size must be a multiple of the 
  /// system page size.
  /// @param size the size to allocate
  /// @return the base pointer of the allocated memory
  void* c_mmap (const long size);

  /// reallocate a memory previously allocated with c_mmap
  /// @param optr  the old base memory pointer
  /// @param osize the old memory size
  /// @param nsize the new memory size
  /// @return the base pointer of the new allocated memory
  void* c_mremap (void* optr, const long osize, const long nsize);

  /// deallocate a memory block previously allocated with c_mmap
  /// @param ptr the base memory pointer
  /// @param size the size of the memory block
  void c_munmap (void* ptr, const long size);
}

#endif
