// ---------------------------------------------------------------------------
// - cmem.hxx                                                                -
// - standard system library - c low level memory function implementation    -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include <unistd.h>
#include <sys/types.h>
#include <sys/mman.h>
#include "cio.hxx"
#include "cmem.hxx"
#include "csys.hxx"

namespace aleph {

  // return the system memory page
  long c_pagesize (void) {
    return sysconf (_SC_PAGESIZE);
  }

  // open dev zero and keep it
  static int c_devzero (void) {
    static int fd = 0;
    if (fd == 0) 
      if ((fd = c_openrw ("/dev/zero")) == -1)
	c_exit (1);
    return fd;
  }

  // allocate a block of memory
  void* c_mmap (const long size) {
    void* ptr = mmap (0,size,PROT_READ|PROT_WRITE,MAP_PRIVATE,
		      c_devzero (),0);
    if (ptr == MAP_FAILED) c_exit (1);
    return ptr;
  }

  // reallocate a block of memory - on sun we have to allocate and copy
  void* c_mremap (void* optr, const long osize, const long nsize) {
    if (nsize <= osize) return optr;
    void* nptr = c_mmap (nsize);
    unsigned char* cnptr = (unsigned char*) nptr;
    unsigned char* coptr = (unsigned char*) optr;
    for (long i = 0; i < osize; i++) *cnptr++ = *coptr++;
    c_munmap (optr, osize);;
    return nptr;
  }
 
  // unmap a memory block
  void c_munmap (void* ptr, const long size) {
    munmap ((caddr_t) ptr,size);
  }
}
