#include "global.h"

extern void Init_gtk_gtk();
extern void Init_gtk_gdk();
#ifdef HAVE_GDKIMLIB
extern void Init_gdkimlib();
extern void Init_gdkimlib2();
#endif

EXTERN VALUE rb_argv, rb_argv0;

static void
gtkerr(mesg)
    char *mesg;
{
    rb_raise(rb_eRuntimeError, "%s", mesg);
}

void
Init_gtk()
{
    int argc, i;
    char **argv;

    gtk_set_locale();

    Init_gtk_gtk();
    Init_gtk_gdk();
#ifdef HAVE_GDKIMLIB
    Init_gdkimlib();
#endif

    argc = RARRAY(rb_argv)->len;
    argv = ALLOCA_N(char*,argc+1);
    argv[0] = STR2CSTR(rb_argv0);
    for (i=0;i<argc;i++) {
	if (TYPE(RARRAY(rb_argv)->ptr[i]) == T_STRING) {
	    argv[i+1] = RSTRING(RARRAY(rb_argv)->ptr[i])->ptr;
	}
	else {
	    argv[i+1] = "";
	}
    }
    argc++;
    {
	/* Gdk modifies sighandlers, sigh */
#ifdef NT
	RETSIGTYPE (*sigfunc[3])();
#else
	RETSIGTYPE (*sigfunc[7])();
#endif

#ifdef NT
	sigfunc[0] = signal(SIGINT, SIG_IGN);
	sigfunc[1] = signal(SIGSEGV, SIG_IGN);
	sigfunc[2] = signal(SIGTERM, SIG_IGN);
#else
	sigfunc[0] = signal(SIGHUP, SIG_IGN);
	sigfunc[1] = signal(SIGINT, SIG_IGN);
	sigfunc[2] = signal(SIGQUIT, SIG_IGN);
	sigfunc[3] = signal(SIGBUS, SIG_IGN);
	sigfunc[4] = signal(SIGSEGV, SIG_IGN);
	sigfunc[5] = signal(SIGPIPE, SIG_IGN);
	sigfunc[6] = signal(SIGTERM, SIG_IGN);
#endif

	gtk_init(&argc, &argv);
#ifdef HAVE_GDKIMLIB
        Init_gdkimlib2();
#endif

#ifdef NT
	signal(SIGINT,  sigfunc[0]);
	signal(SIGSEGV, sigfunc[1]);
	signal(SIGTERM, sigfunc[2]);
#else
	signal(SIGHUP,  sigfunc[0]);
	signal(SIGINT,  sigfunc[1]);
	signal(SIGQUIT, sigfunc[2]);
	signal(SIGBUS,  sigfunc[3]);
	signal(SIGSEGV, sigfunc[4]);
	signal(SIGPIPE, sigfunc[5]);
	signal(SIGTERM, sigfunc[6]);
#endif
    }

    for (i=1;i<argc;i++) {
	RARRAY(rb_argv)->ptr[i-1] = rb_obj_taint(rb_str_new2(argv[i]));
    }
    RARRAY(rb_argv)->len = argc-1;

    g_set_error_handler(gtkerr);
    g_set_warning_handler(gtkerr);
}
