#
# $Header: /usr/local/cvsroot/pythondoc/codeutil.py,v 1.2 1999/05/01 01:20:11 daniel Exp $
#
# Copyright (C) Daniel Larsson
# All Rights Reserved.
#
# See copyright notice in the file 'LICENSE.TXT', which should have accompanied
# this distribution.
#
"""Utility functions for quering function and code objects."""

CO_VARARGS = 4
CO_VARKEYWORDS = 8

def getarguments(func):
    """Returns a sequence describing a functions arguments.

    The sequence contains three lists, the first contains the
    names of the standard arguments, the second contains tuples
    containing the name and its default value, and the third
    contains tuples of (argtype, argname) for the '*args' and
    '**kw' arguments, if they exist. 'argtype' is either
    CO_VARARGS or CO_VARKEYWORDS.

    Note that this function depends pretty heavily on internal
    structures of the Python interpreter... 
    """
    
    names = func.func_code.co_varnames
    nrargs = func.func_code.co_argcount
    if func.func_defaults:
	nrdefaults = len(func.func_defaults)
    else:
	nrdefaults = 0
    stdargs = names[:nrargs-nrdefaults]
    if func.func_defaults:
	defaults = tuple(map(None, names[nrargs-nrdefaults:nrargs],
			     func.func_defaults))
    else:
        defaults = ()
    varargs = []
    ix = nrargs
    if func.func_code.co_flags & CO_VARARGS:
	varargs.append((CO_VARARGS, names[ix]))
	ix = ix+1
    if func.func_code.co_flags & CO_VARKEYWORDS:
	varargs.append((CO_VARKEYWORDS, names[ix]))
    return (stdargs, defaults, tuple(varargs))

def test():
    def f(a, b=1, *args, **kw): x = 1
    def g(a, b=1, **kw): x = 1
    def h(a, b, c): pass
    def i(): pass
    print getarguments(f)
    print getarguments(g)
    print getarguments(h)
    print getarguments(i)

if __name__ == "__main__":
    test()

#
# $Log: codeutil.py,v $
# Revision 1.2  1999/05/01 01:20:11  daniel
# Removed Windows style line endings.
#
# 
# *****************  Version 2  *****************
# User: Daniel       Date: 98-08-06   Time: 17:05
# Updated in $/Pythondoc
# Added header and footer.
# 

