#
# $Header: /usr/local/cvsroot/pythondoc/xref/internalXref.py,v 1.2 1999/05/01 01:11:28 daniel Exp $
#
# Copyright (C) Daniel Larsson
# All Rights Reserved.
#
# See copyright notice in the file 'LICENSE.TXT', which should have accompanied
# this distribution.
#

"""Internal crossreferences module.

This module takes care of internal crossreferences, i.e. references
to other Python objects in docstrings. An example is the [Xref]
reference.

.. [Xref] pythondoc.xref.xref
"""

__author__ = "Daniel Larsson"
__version__ = "$Revision: 1.2 $"[11:-2]

import pythondoc.docobjects

class InternalXref:
    def resolve_to_path(self, object, xref, globals, locals):
	try:
	    refobj = eval(xref, globals, locals)
	except:
	    print object
	    refobj = getattr(object, xref)
	docobject = pythondoc.docobjects.create_docobject(refobj)
	return docobject.internalXref()

import xref
xref.register_xref(InternalXref(), '')

#
# $Log: internalXref.py,v $
# Revision 1.2  1999/05/01 01:11:28  daniel
# *** empty log message ***
#
# 
# *****************  Version 2  *****************
# User: Daniel       Date: 98-08-06   Time: 16:56
# Updated in $/Pythondoc/xref
# Added header and footer.
# Added debug code.
# 
