/********************************************************************************
*                                                                               *
*                          C o l o r   S e l e c t o r                          *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXColorSelector.h,v 1.4 1999/11/12 07:59:15 jeroen Exp $                 *
********************************************************************************/
#ifndef FXCOLORSELECTOR_H
#define FXCOLORSELECTOR_H


// File selection widget
class FXAPI FXColorSelector : public FXPacker {
  FXDECLARE(FXColorSelector)
protected:
  FXTabBook   *panels;                // Color panes
  FXColorWell *well;                  // Main well
  FXList      *list;                  // List of color names
  FXSlider    *rgbaslider[4];         // RGBA sliders
  FXTextField *rgbatext[4];           // RGBA text fields
  FXSlider    *hsvaslider[4];         // HSVA sliders
  FXTextField *hsvatext[4];           // HSVA text fields
  FXSlider    *cmyslider[4];          // CMY sliders
  FXTextField *cmytext[4];            // CMY text fields
  FXColorWell *colorwells[24];        // Custom color wells
  FXGIFIcon   *rgbmodeicon;           // Icon for RGB mode
  FXGIFIcon   *hsvmodeicon;           // Icon for HSV mode
  FXGIFIcon   *cmymodeicon;           // Icon for CMY mode
  FXGIFIcon   *txtmodeicon;           // Icon for TEXT mode
  FXButton    *accept;                // Accept button
  FXButton    *cancel;                // Cancel button
  FXfloat      rgba[4];               // Accurate RGBA color
  FXfloat      hsva[4];               // Accurate HSVA color
protected:
  static const FXchar* wellname[24];  // Well names
protected:
  FXColorSelector(){}
  void updateWell();
private:
  FXColorSelector(const FXColorSelector&);
  FXColorSelector &operator=(const FXColorSelector&);
public:
  long onCmdColor(FXObject*,FXSelector,void*);
  long onChgColor(FXObject*,FXSelector,void*);
  long onCmdWell(FXObject*,FXSelector,void*);
  long onChgWell(FXObject*,FXSelector,void*);
  long onCmdRGBSlider(FXObject*,FXSelector,void*);
  long onUpdRGBSlider(FXObject*,FXSelector,void*);
  long onCmdRGBText(FXObject*,FXSelector,void*);
  long onUpdRGBText(FXObject*,FXSelector,void*);
  long onCmdHSVSlider(FXObject*,FXSelector,void*);
  long onUpdHSVSlider(FXObject*,FXSelector,void*);
  long onCmdHSVText(FXObject*,FXSelector,void*);
  long onUpdHSVText(FXObject*,FXSelector,void*);
  long onCmdCMYSlider(FXObject*,FXSelector,void*);
  long onUpdCMYSlider(FXObject*,FXSelector,void*);
  long onCmdCMYText(FXObject*,FXSelector,void*);
  long onUpdCMYText(FXObject*,FXSelector,void*);
  long onCmdList(FXObject*,FXSelector,void*);
  long onCmdCustomWell(FXObject*,FXSelector,void*);
  long onChgCustomWell(FXObject*,FXSelector,void*);
  long onCmdSetValue(FXObject*,FXSelector,void*);
  long onCmdActivePane(FXObject*,FXSelector,void*);
public:
  enum{
    ID_CUSTOM_FIRST=FXPacker::ID_LAST,
    ID_CUSTOM_LAST=ID_CUSTOM_FIRST+24,
    ID_RGB_RED_SLIDER,
    ID_RGB_GREEN_SLIDER,
    ID_RGB_BLUE_SLIDER,
    ID_RGB_ALPHA_SLIDER,
    ID_RGB_RED_TEXT,
    ID_RGB_GREEN_TEXT,
    ID_RGB_BLUE_TEXT,
    ID_RGB_ALPHA_TEXT,
    ID_HSV_HUE_SLIDER,
    ID_HSV_SATURATION_SLIDER,
    ID_HSV_VALUE_SLIDER,
    ID_HSV_ALPHA_SLIDER,
    ID_HSV_HUE_TEXT,
    ID_HSV_SATURATION_TEXT,
    ID_HSV_VALUE_TEXT,
    ID_HSV_ALPHA_TEXT,
    ID_CMY_CYAN_SLIDER,
    ID_CMY_MAGENTA_SLIDER,
    ID_CMY_YELLOW_SLIDER,
    ID_CMY_ALPHA_SLIDER,
    ID_CMY_CYAN_TEXT,
    ID_CMY_MAGENTA_TEXT,
    ID_CMY_YELLOW_TEXT,
    ID_CMY_ALPHA_TEXT,
    ID_COLOR_LIST,
    ID_WELL_CHANGED,
    ID_COLOR,
    ID_ACTIVEPANE,
    ID_LAST
    };
public:
  FXColorSelector(FXComposite *p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
  virtual void create();
  FXButton *acceptButton() const { return accept; }
  FXButton *cancelButton() const { return cancel; }
  void setRGBA(FXColor clr);
  FXColor getRGBA() const;
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXColorSelector();
  };


#endif
