/*
  DLL entry routine

  Copyright (C) 1997 NET-Community

  Original Author:  Scott Christley <scottc@net-community.com>
  Created: August 1997
   
  This file is part of the Foundation Extensions Library.

  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted, provided
  that the above copyright notice appear in all copies and that both that
  copyright notice and this permission notice appear in supporting
  documentation.

  We disclaim all warranties with regard to this software, including all
  implied warranties of merchantability and fitness, in no event shall
  we be liable for any special, indirect or consequential damages or any
  damages whatsoever resulting from loss of use, data or profits, whether in
  an action of contract, negligence or other tortious action, arising out of
  or in connection with the use or performance of this software.
*/

#include <windows.h>

/* Only if using Microsoft's tools and libraries */
#ifdef __MS_WIN32__
#include <stdio.h>
WINBOOL WINAPI _CRT_INIT( HINSTANCE hinstDLL, DWORD fdwReason,
			  LPVOID lpReserved );

// Global errno isn't defined in Microsoft's thread safe C library
void errno()
{}

#endif /* __MS_WIN32__ */

//
// DLL entry function for the FoundationExt Library
// This function gets called everytime a process/thread attaches to DLL
//
WINBOOL WINAPI DllMain(HANDLE hInst, ULONG ul_reason_for_call,
		       LPVOID lpReserved)
{
  switch(ul_reason_for_call)
    {
    case DLL_PROCESS_ATTACH:
	{
#ifdef __MS_WIN32__
	  /* Initialize the Microsoft C stdio DLL */
	  _CRT_INIT(hInst, ul_reason_for_call, lpReserved);

	  /* Initialize the FoundationExt Library runtime structures */
	  gnustep_db_init_runtime();
#endif /* __MS_WIN32__ */

	  break;
	}

    case DLL_PROCESS_DETACH:
      {
	break;
      }

    case DLL_THREAD_ATTACH:
      {
#ifdef __MS_WIN32__
	/* Initialize C stdio DLL */
	_CRT_INIT(hInst, ul_reason_for_call, lpReserved);
#endif /* __MS_WIN32__ */

	break;
      }

    case DLL_THREAD_DETACH:
      {
	break;
      }
    }

  return TRUE;
}
