/*
 * giidemo.c - written in 1998 by Andreas Beck   becka@ggi-project.org
 *
 * This is a demonstration of LibGII's functions and can be used as a 
 * reference programming example.
 *
 *   This software is placed in the public domain and can be used freely
 *   for any purpose. It comes without any kind of warranty, either
 *   expressed or implied, including, but not limited to the implied
 *   warranties of merchantability or fitness for a particular purpose.
 *   Use it at your own risk. the author is not responsible for any damage
 *   or consequences raised by use or inability to use this program.
 */

/* Include the necessary headers used for e.g. error-reporting.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

/* Include the LibGGI declarations.
 */
#include <ggi/ggi.h>
#include <ggi/gii.h>

static void test_showevent(ggi_visual_t *vis,ggi_event *ev)
{
	int y;
	char buffer[256];
	char *str=buffer;
	
	str+=sprintf(str,"o:%8x ",ev->any.origin);
	switch(ev->any.type)
	{
		case evKeyPress:
			str+=sprintf(str,"KeyPress    ");goto showkey;
		case evKeyRepeat:
			str+=sprintf(str,"KeyRepeat   ");goto showkey;
		case evKeyRelease:
			str+=sprintf(str,"KeyRelease  ");
			showkey:
			str+=sprintf(str,"sym=%4x label=%4x button=%4x",
				ev->key.sym,ev->key.label,ev->key.button);
			ggiPuts(vis,0,10,buffer);
			break;
		case evValAbsolute:
			str+=sprintf(str,"ValAbsolute ");goto showval;
		case evValRelative:
			str+=sprintf(str,"ValAbsolute ");
			showval:
			for(y=0;y<ev->val.count;y++)
				str+=sprintf(str,"[%2d]=%d",ev->val.first+y,ev->val.value[y]);
			ggiPuts(vis,0,10,buffer);
			break;
		case evPtrAbsolute:
			str+=sprintf(str,"PtrAbsolute ");goto showptr;
		case evPtrRelative:
			str+=sprintf(str,"PtrAbsolute ");
			showptr:
			str+=sprintf(str,"x=%4x y=%4x z=%4x w=%4x",
				ev->pmove.x,ev->pmove.y,ev->pmove.z,ev->pmove.wheel);
			ggiPuts(vis,0,10,buffer);
			break;
		default:
			str+=sprintf(str,"event: type=%d ",ev->any.type);
			for(y=0;y<ev->any.size;y++)
				str+=sprintf(str,"%02x  ",((unsigned char *)ev)[y]);
			ggiPuts(vis,0,10,buffer);
	}
}

static void test_ggi_poll(ggi_visual_t vis, struct timeval *tval)
{
	ggi_event_mask	mask;
	ggi_event	event;
	char text[256];

	mask=ggiEventPoll(vis,emAll,tval);
	sprintf(text, "0x%8x=ggiEventPoll(%p,emAll,&{%d,%d});",
		mask, vis, (int)tval->tv_sec, (int)tval->tv_usec);
	ggiPuts(vis,0,20,text);
	if (mask) 
	{
		/*printf("0x%8x ",mask);*/
		ggiEventRead(vis,&event,emAll);
		test_showevent(vis,&event);
	}
	while(mask)
	{
		struct timeval	tv= {0,0};
		mask=ggiEventPoll(vis,emAll,&tv);
		if (mask) 
		{
			/*printf("0x%8x ",mask);*/
			ggiEventRead(vis,&event,emAll);
			test_showevent(vis,&event);
		}
	}
}

#if 0
typedef struct grshowcoord { int min,max,curr; } coor_t;

typedef struct grshow {

	coor_t	x,y;
	ggi_color	col;
	int style;
	
} show_t;

int virtx=640;
int virty=480;

static void graph_showone(ggi_visual_t vis,show_t *typ)
{
	int x,y;
	
	if (typ->x.min>typ->x.curr) typ->x.min=typ->x.curr;
	if (typ->y.min>typ->y.curr) typ->y.min=typ->y.curr;
	if (typ->x.max<typ->x.curr) typ->x.max=typ->x.curr;
	if (typ->y.max<typ->y.curr) typ->y.max=typ->y.curr;

	x=(virtx-1-10)*(typ->x.curr-typ->x.min)/(typ->x.max-typ->x.min+1);
	y=(virty-1-10)*(typ->y.curr-typ->y.min)/(typ->y.max-typ->y.min+1);

	ggiSetGCForeground(vis,ggiMapColor(vis,&(typ->col)));
	printf("x,y=%d,%d %d %d %d\n",x,y,typ->x.min,typ->x.curr,typ->x.max);
	switch(typ->style)
	{
		case 0:	ggiDrawBox (vis,x,y,10,10);break;
		case 1:	ggiDrawLine(vis,x,y,x+10,x+10); ggiDrawLine(vis,x+10,y,x,y+10);break;
		case 2:	ggiDrawLine(vis,x+5,y,x+5,x+10);ggiDrawLine(vis,x,y+5,x+10,y+5);break;
	}
}

show_t mine;

static void graph_showevent(ggi_visual_t vis,ggi_event *ev)
{
	int y;

	show_t *currshow;
	
	currshow=&mine;
	
	switch(ev->any.type)
	{
		case evKeyPress:
			currshow->style=0;goto showkey;
		case evKeyRepeat:
			currshow->style=1;goto showkey;
		case evKeyRelease:
			currshow->style=2;
			showkey:
			currshow->x.curr=ev->key.sym;
			currshow->x.curr=ev->key.label;
			graph_showone(vis,currshow);
			break;
		case evValAbsolute:
			currshow->style=0;goto showval;
		case evValRelative:
			currshow->style=1;
			showval:
			for(y=0;y<ev->val.changed;y++)
			{
				if (ev->val.first+y==0)	currshow->x.curr=ev->val.value[y];
				if (ev->val.first+y==1)	currshow->x.curr=ev->val.value[y];
			}
			graph_showone(vis,currshow);
			break;
		case evPtrAbsolute:
			currshow->style=0;goto showptr;
		case evPtrRelative:
			currshow->style=1;
			showptr:
			currshow->x.curr=ev->pmove.x;
			currshow->x.curr=ev->pmove.y;
			graph_showone(vis,currshow);
			break;
		default:
			printf("event: type=%d\n",ev->any.type);
			for(y=0;y<ev->any.size;y++)
				printf("%02x  ",((unsigned char *)ev)[y]);
			printf("\n");
	}
}

static void ggi_showpoll(ggi_visual_t vis, struct timeval *tval)
{
	ggi_event_mask	mask;
	ggi_event	event;

	mask=ggiEventPoll(vis,emAll,tval);

	while (mask) 
	{
		struct timeval	tv= {0,0};
		ggiEventRead(vis,&event,emAll);
		graph_showevent(vis,&event);
		mask=ggiEventPoll(vis,emAll,&tv);
	}
	ggiFlush(vis);
}
#endif

/* The main routine.
 * It will just open a gii_input and do some basic tests.
 */
int main(int argc, char **argv)
{
	/* First we define a bunch of variables we will access throughout the
	 * main() function. Most of them are pretty meaningless loop-counters
	 * and helper-variables.
	 */
	int x;
	struct timeval tval;

 	gii_input_t inp;
 	ggi_visual_t vis;
 	ggi_color white={0xffff,0xffff,0xffff};

#if 0
	/* FIXME HACK ! */
	mine.col.r=0xffff;rand()|0x7ff;
	mine.col.g=0xffff;rand();
	mine.col.b=0xffff;rand();
	mine.x.min=mine.y.min= 999999;
	mine.x.max=mine.y.max=-999999;
#endif
	
	/* Initialize the GGI library. This must be called before any other 
	 * GGI function. As we use the builtin-GII.
	 */
	if (ggiInit() != 0) {
		fprintf(stderr, "%s: unable to initialize libggi, exiting.\n",
			argv[0]);
		exit(1);
	}

	printf("Now going to the graphical tests.\n");

        vis = ggiOpen(NULL);
        
	if (vis == NULL) {
		fprintf(stderr, "Failed to open visual.\n");
		exit(1);
	}

	ggiSetGraphMode(vis,GGI_AUTO,GGI_AUTO,GGI_AUTO,GGI_AUTO,GT_AUTO);
	
	ggiSetGCForeground(vis,ggiMapColor(vis,&white));

	ggiPuts(vis,0,0,"Only native input sources.");
	for(x=0;x<10;x++)
	{
		tval.tv_sec = 1*x;
		tval.tv_usec = 0;
		test_ggi_poll(vis,&tval);
	}

	ggiPuts(vis,0,0,"Joining in stdin.");

	if ((inp=giiOpen("input-stdin",NULL)) == NULL) {
		fprintf(stderr,
			"%s: unable to open stdin-source, exiting.\n",
			argv[0]);
		ggiExit();
		exit(1);
	}

	ggiJoinInputs(vis,inp);
	for(x=0;x<10;x++)
	{
		tval.tv_sec = 1*x;
		tval.tv_usec = 0;
		test_ggi_poll(vis,&tval);
	}

	ggiPuts(vis,0,0,"Joyning in pcjoy.");

	if ((inp=giiOpen("input-pcjoy",NULL)) == NULL) {
		fprintf(stderr,
			"%s: unable to open pcjoy-source, exiting.\n",
			argv[0]);
		ggiExit();
		exit(1);
	}

	ggiJoinInputs(vis,inp);
	for(x=0;x<10;x++)
	{
		tval.tv_sec = 1*x;
		tval.tv_usec = 0;
		test_ggi_poll(vis,&tval);
	}

#if 0
	ggiPuts(vis,0,0,"Now going into a graphical event viewer.");

	for(x=0;x<1000;x++)
	{
		tval.tv_sec = 1;
		tval.tv_usec = 0;
		ggi_showpoll(vis,&tval);
	}
#endif

	ggiClose(vis);
	
	/* Now close down LibGGI. */
	ggiExit();	

	/* Terminate the program.*/
	return 0;
}
