/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998, 1999  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL_BWin.h,v 1.2 1999/11/23 19:01:42 hercules Exp $";
#endif

#ifndef _SDL_BWin_h
#define _SDL_BWin_h

#include <stdio.h>
#include <AppKit.h>
#include <InterfaceKit.h>

#include "SDL_BeApp.h"
#include "SDL_events.h"
#include "SDL_BView.h"

extern "C" {
#include "SDL_events_c.h"
};

class SDL_BWin : public BWindow
{
public:
	SDL_BWin(BRect bounds) :
			BWindow(bounds, "Untitled", B_TITLED_WINDOW,
                                        (B_NOT_RESIZABLE|B_NOT_ZOOMABLE)) {
		++alive;
		SDL_View = new SDL_BView(bounds);
		AddChild(SDL_View);
		Unlock();
		shown = false;
	}
	virtual ~SDL_BWin() {
		--alive;
	}

	/* Override the Show() method so we can tell when we've been shown */
	virtual void Show(void) {
		BWindow::Show();
		shown = true;
	}
	virtual bool Shown(void) {
		return (shown);
	}

	virtual void SetBitmap(BBitmap *bitmap) {
		SDL_View->SetBitmap(bitmap);
	}
	virtual bool BeginDraw(void) {
		return(Lock());
	}
	virtual void DrawAsync(BRect updateRect) {
		SDL_View->DrawAsync(updateRect);
	}
	virtual void EndDraw(void) {
		SDL_View->Sync();
		Unlock();
	}
	virtual SDL_BView *View(void) {
		return(SDL_View);
	}

	/* Hook functions -- overridden */
	virtual void Minimize(bool minimize) {
		/* This is only called when mimimized, not when restored */
		//SDL_PrivateAppActive(minimize, SDL_APPACTIVE);
		BWindow::Minimize(minimize);
	}
	virtual void WindowActivated(bool active) {
		SDL_PrivateAppActive(active, SDL_APPINPUTFOCUS);
	}
	virtual bool QuitRequested(void) {
		if ( SDL_BeAppActive > 0 ) {
			SDL_PrivateQuit();
			/* We don't ever actually close the window here because
			   the application should respond to the quit request,
			   or ignore it as desired.
			 */
			return(false);
		}
		return(true);	/* Close the app window */
	}

	/* A way for SDL to see if the window pointer is valid */
	static bool Alive(void) {
		return(alive > 0);
	}

private:
	SDL_BView *SDL_View;

	static int alive;
	bool shown;
};

#endif /* _SDL_BWin_h */
