
/* Simple test of the SDL threading code and error handling */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

#include "SDL.h"
#include "SDL_thread.h"

static int alive = 0;

int ThreadFunc(void *data)
{
	/* Set the child thread error string */
	SDL_SetError("Thread %s (%d) had a problem: %s",
			(char *)data, SDL_ThreadID(), "nevermind");
	while ( alive ) {
		printf("Thread '%s' is alive!\n", (char *)data);
		SDL_Delay(1*1000);
	}
	printf("Child thread error string: %s\n", SDL_GetError());
	return(0);
}

static void killed(int sig)
{
	printf("Killed with SIGTERM, waiting 5 seconds to exit\n");
	SDL_Delay(5*1000);
	alive = 0;
	exit(0);
}

main(int argc, char *argv[])
{
	SDL_Thread *thread;

	/* Load the SDL library */
	if ( SDL_Init(0) < 0 ) {
		fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());
		exit(1);
	}
	atexit(SDL_Quit);

	/* Set the error value for the main thread */
	SDL_SetError("No worries");

	alive = 1;
	thread = SDL_CreateThread(ThreadFunc, "#1");
	if ( thread == NULL ) {
		fprintf(stderr, "Couldn't create thread: %s\n", SDL_GetError());
		exit(1);
	}
	SDL_Delay(5*1000);
	printf("Waiting for thread #1\n");
	alive = 0;
	SDL_WaitThread(thread, NULL);

	printf("Main thread error string: %s\n", SDL_GetError());

	exit(0);
}
