#!/usr/bin/perl
#
# Program to take a set of header files and generate DLL export definitions

while ( ($file = shift(@ARGV)) ) {
	if ( ! defined(open(FILE, $file)) ) {
		warn "Couldn't open $file: $!\n";
		next;
	}
	$printed_header = 0;
	$file =~ s,.*/,,;
	while (<FILE>) {
		if ( /^SDL_DEFUN\(.*,\s*([^\s]+),/ ) {
			print "\t_$1\n";
		}
	}
	close(FILE);
}
# Special exports not in the header files
print "\t_SDL_Init\n";
print "\t_SDL_Quit\n";
print "\t_SDL_LockSO\n";
print "\t_SDL_InitQuickDraw\n";
