/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */

#ifndef VDKOBJ_H
#define VDKOBJ_H
#include <gtk/gtk.h>
#include <vdk/vdktypes.h>
#include <vdk/dlist.h>
#include <vdk/vdkutils.h>
#include <vdk/rawobj.h>
#include <vdk/vdkprops.h>
#include <vdk/vdkstring.h>

#ifdef USE_SIGCPLUSPLUS
#     include <vdk/sigc_addon.h>
#endif /* USE_SIGCPLUSPLUS */

class VDKForm;
class VDKTooltip;
class VDKFont;
class VDKObject;

enum { object_class, form_class , container_class};

/*
 */
typedef VDKList<VDKObject> ItemList;
typedef VDKListiterator<VDKObject> ItemListIterator;

/*
 */
struct VDKObjectSignal {
    void* obj;
    int signal;
};

/*
 */
class VDKObjectSignalUnit
{
public:
    void* owner;
    void* obj;
    VDKString signal;
    VDKObjectSignalUnit(void* owner,void *obj, char* signal):
        owner(owner),obj(obj),signal(signal) {}
    ~VDKObjectSignalUnit() {}
};

typedef VDKList<VDKObjectSignalUnit> SignalUnitList;
typedef VDKListiterator<VDKObjectSignalUnit> SignalUnitListIterator;

/*
 */
class VDKObjectEventUnit
{
public:
    void* owner;
    void* obj;
    VDKString signal;
    VDKObjectEventUnit(void* owner,void *obj, char* signal):
        owner(owner),obj(obj),signal(signal) {}
    ~VDKObjectEventUnit() {}
};

typedef VDKList<VDKObjectEventUnit> EventUnitList;
typedef VDKListiterator<VDKObjectEventUnit> EventUnitListIterator;

/*
=============
SIZE PROPERTY
=============
*/
typedef VDKReadWriteValueProp<VDKObject,VDKPoint> SizeOProp;

class SizeObjectProp: public SizeOProp
{
public:
    SizeObjectProp(){}
    SizeObjectProp(char* name, VDKObject* object,
                   void (VDKObject::*write)(VDKPoint) =  NULL,
                   VDKPoint (VDKObject::*read)(void) = NULL) : SizeOProp(name,object,VDKPoint(0,0),write,read) {}
    void operator = (VDKPoint);
    operator VDKPoint();
};

/*
  ===============
  VDKOBJECT CLASS
  ===============
*/
typedef VDKList<VDKRawObject> RawList;
typedef VDKListiterator<VDKRawObject> RawListIterator;


#ifndef USE_SIGCPLUSPLUS
class VDKObject
#else
class VDKObject : public SigC::Object
#endif
{

 public:
  /*
    properties
  */
  VDKReadWriteValueProp<VDKObject,VDKRgb> NormalBackground;
  VDKReadWriteValueProp<VDKObject,VDKRgb> PrelightBackground;
  VDKReadWriteValueProp<VDKObject,VDKRgb> InsensitiveBackground;
  VDKReadWriteValueProp<VDKObject,VDKRgb> ActiveBackground;
  VDKReadWriteValueProp<VDKObject,VDKRgb> SelectedBackground;
  VDKReadWriteValueProp<VDKObject,VDKRgb> Foreground;
  VDKReadWriteValueProp<VDKObject,VDKFont*> Font;
  SizeObjectProp Usize;
  VDKReadWriteValueProp<VDKObject,bool> Enabled;
  VDKReadWriteValueProp<VDKObject,VDKCursorType> Cursor;
  VDKReadWriteValueProp<VDKObject,bool> Visible;
  int Tag;

// GTK_STATE_NORMAL = 0, GTK_STATE_ACTIVE, GTK_STATE_PRELIGHT,
  // GTK_STATE_SELECTED,GTK_STATE_INSENSITIVE
  void SetNormalBackground(VDKRgb c) {
      SetBackground(c,GTK_STATE_NORMAL);
  }
  void SetPrelightBackground(VDKRgb c) {
      SetBackground(c,GTK_STATE_PRELIGHT);
  }
  void SetInsensitiveBackground(VDKRgb c) {
      SetBackground(c,GTK_STATE_INSENSITIVE);
  }
  void SetActiveBackground(VDKRgb c) {
      SetBackground(c,GTK_STATE_ACTIVE);
  }
  void SetSelectedBackground(VDKRgb c) {
      SetBackground(c,GTK_STATE_SELECTED);
  }
  VDKRgb
    GetBackground(GtkStateType state = GTK_STATE_NORMAL);
  VDKRgb
    GetForeground(GtkStateType state = GTK_STATE_NORMAL);
private:
  /*
    copy and assignement prohibited
    */
    friend class VDKRawObject;
    VDKObject(VDKObject& ) {}
    VDKObject& operator=(VDKObject& ) {
        return *this;
    }
    VDKTooltip* tip;
protected:
    ItemList items;
    ItemList garbages;
    RawList  raws;
    SignalUnitList suList;
    EventUnitList euList;
    VDKObjectSignal s_clicked,s_pressed,s_released,s_enter,s_leave,
        s_list_select,s_list_unselect,s_list_click_column,s_realize,
            s_toggled,s_value_changed,s_child_attached,s_child_detached;
    VDKForm* owner;
 //  int id;
    //
    GtkWidget* widget;
    // connecting widget
    GtkWidget* sigwid;
    VDKObject* parent;
    static void VDKEventPipe(GtkWidget* w, GdkEvent* event, void* obj);
    void _setBackground_(GtkWidget* wid,
                         int red,int green, int blue,
                         GtkStateType state);
    void _setForeground_(GtkWidget* wid,
                         int red,int green, int blue,
                         GtkStateType state);
    void _setFont_(GtkWidget* wid, VDKFont* f);
    void ConnectDefaultEvents();
    void ConnectDefaultSignals();
    void SignalEmit(int signal, int level);
    virtual void ShowWidget(bool visible);
public:
    //
    VDKObject(VDKForm* owner = NULL);
    VDKObject(VDKForm* owner, GtkWidget* widget);
    virtual ~VDKObject();
    bool Destroy();
    //
    virtual int isA() { return object_class; }
    VDKForm* Owner() {
        return owner;
    }
    virtual GtkWidget* Widget();

    GtkWidget* ConnectingWidget();

    GtkWidget* WrappedWidget();

    virtual void SetFont(VDKFont* f);
    VDKFont* GetFont() {
        return Font;
    }

    void SetVisible(bool visible);

    bool GetVisible() {
        return GTK_WIDGET_VISIBLE(widget);
    }
    void SetCursor(VDKCursorType);
    VDKCursorType     GetCursor() {
        return Cursor;
    }
    virtual void SetForeground(VDKRgb color,
                               GtkStateType state = GTK_STATE_NORMAL);
    void SetNormalForeground(VDKRgb color) {
        SetForeground(color);
    }
    virtual void SetBackground(VDKRgb color,
                               GtkStateType state = GTK_STATE_NORMAL);
    void SetSize(int w, int h) {
        if(GTK_IS_WIDGET(widget))
            gtk_widget_set_usize(GTK_WIDGET(widget),w,h);
    }

    void SetUsize(VDKPoint s) {
        SetSize(s.X(),s.Y());
    }
    virtual void Enable(bool flag = true);
    bool GetEnabled() {
        return Enabled;
    }
    virtual void SetTip(char* );
    virtual void Add(VDKObject* obj, int justify = l_justify,
                     int expand = TRUE, int fill = TRUE ,
                     int padding = 0);
    ItemList& Items() {
        return items;
    }
    ItemList& Garbages() {
        return garbages;
    }
    RawList& Raws() {
        return raws;
    }
    void Draw(GdkRectangle* area = NULL);
    // obsolete
    virtual void Setup() {}
    void SignalEmit(int signal);
    void SignalEmit(char* sig);
    void SignalEmitParent(int signal) {
        SignalEmit(signal,Parent_level);
    }
    void SignalEmitParent(char* sig);
    void GrabFocus();
  /*
    internal use
    */
  /*
   */
    void AddItem(VDKObject* item);
    void RemoveItem(VDKObject* item);
    void RemoveItems();
  /*
==================== signal/event management  ======================
  */
    VDKObject* Parent(VDKObject* p = NULL) {
        if(p) parent = p; return parent;
    }
    // signal and events default dispatchers for class level
    static void VDKSignalPipe(GtkWidget* w, void* obj);
    virtual int VDKObjectSignalResponse(GtkWidget* , int , void*, bool) {
        return FALSE;
    }
    virtual int VDKObjectEventResponse(GtkWidget* , GdkEvent*, void*, bool) {
        return FALSE;
    }
    virtual int ObjectSignalDetach(int , int ) {
        return -1;
    }
    virtual bool ObjectSignalAttach(int ) {
        return false;
    }
    virtual int ObjectEventDetach(VDKEvent ) {
        return -1;
    }
    virtual bool ObjectEventAttach(int ) {
        return false;
    }
 protected:
     virtual int VDKObjectSignalResponseTableSize() {
         return 0;
     }
     virtual int VDKObjectEventResponseTableSize() {
         return 0;
     }
  /*
   */
  // signal and events default dispatchers for parent level
public:
    virtual int VDKSignalResponse(GtkWidget* , int , void*, void *, bool) {
        return 0;
    }
    virtual int VDKEventResponse(GtkWidget* , GdkEvent* , void*, void*, bool ) {
        return 0;
    }
    virtual int SignalDetach(VDKObject* , int ) {
        return -1;
    }
    virtual bool SignalAttach(int ) {
        return false;
    }
    virtual int EventDetach(VDKObject* ,VDKEvent ) {
        return -1;
    }
    virtual bool EventAttach(int ) {
        return false;
    }
protected:
    virtual int VDKSignalResponseTableSize() {
        return 0;
    }
    virtual int VDKEventResponseTableSize() {
        return 0;
    }
  /*
==================== signal management ala Gtk+ ======================
  */
public:
  // connects an object to a this method (object and method
  // in different classes
    int SignalConnect(VDKObject* , char* ,bool (VDKObject::*)(VDKObject*), bool,bool) {
        return -1;
    }
  // connects this to a this method (object and method
  // in same class
    int SignalConnect(char* ,bool (VDKObject::*)(VDKObject*), bool,bool) {
        return -1;
    }
   // general signal unit response (at this level simply answer false)
    virtual int VDKSignalUnitResponse(GtkWidget* , char* , void*) {
        return 0;
    }
  // disconnect a signal from signal units list
    bool SignalDisconnect(int) {
        return false;
    }
  // find signal at class level
    virtual bool FindSignalAtClassLevel(VDKObject* , VDKString& ) {
        return false;
    }
  // find signal at parent level
    virtual bool FindSignalAtParentLevel(VDKObject* , VDKString& ) {
        return false;
    }
protected:
    // unique Gtk+ callback that redirects to
    // above VDKSignalUnitResponse()
    static void VDKSignalUnitPipe(GtkWidget* , void* );
  /*
==================== event management ala Gtk+ ======================
  */
public:
      virtual bool FindEventAtClassLevel(VDKObject* , VDKString& ) {
          return false;
      }
      virtual bool FindEventAtParentLevel(VDKObject* , VDKString& ) {
          return false;
      }
      virtual int  VDKEventUnitResponse(GtkWidget* , char* , GdkEvent* , void*) {
          return 0;
      }
      int EventConnect(VDKObject* , char* , bool (VDKObject::*) (VDKObject* , GdkEvent*), bool ) {
          return -1;
      }
      int EventConnect(char* , bool (VDKObject::*) (VDKObject* , GdkEvent*), bool) {
          return -1;
      }
      bool EventDisconnect(int ) {
          return false;
      }
      virtual int  VDKSignalResponseListSize() {
          return 0;
      }
protected:
    // unique Gtk+ callback that redirects to
    // above VDKEventUnitResponse()
    static void VDKEventUnitPipe(GtkWidget* , GdkEvent*, void* );
#ifdef USE_SIGCPLUSPLUS
 public:
    VDKSignal1<void, char*> OnKeyPress;
    VDKSignal1<void, char*> OnKeyRelease;

 protected:
    // will be overriden in some subclasses, but there is no need to make
    // it 'virtual'.
    static void make_gtksigc_connection(VDKObject* obj);
 private:
    static void _handle_key_press(GtkWidget* wid, GdkEventKey *event,
				  gpointer obj);
    static void _handle_key_release(GtkWidget* wid, GdkEventKey *event,
				    gpointer);
#endif
};
#endif








