/*								-*- C++ -*-
 * $Id: DEV_memorydc.cpp,v 1.2 1998/12/23 13:43:02 wmglo Exp $
 *
 * Purpose: device context to draw into wxBitmaps
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "DEV_memorydc.h"
#endif

#define  Uses_XLib
#define  Uses_wxBitmap
#define  Uses_wxMemoryDC
#include "wx.h"

IMPLEMENT_DYNAMIC_CLASS(wxMemoryDC, wxWindowDC)

wxMemoryDC::wxMemoryDC(void) : wxWindowDC()
{
    __type = wxTYPE_DC_MEMORY;

    device = wxDEVICE_MEMORY;

    // the memory DC is at construction an unusable class because
    // there is no drawable. The initialization will be done with
    // wxMemoryDC::SelectObject(wxBitmap *bitmap)
}

wxMemoryDC::wxMemoryDC(wxWindowDC *WXUNUSED(old_dc)) : wxWindowDC()
{
    // I don't know what "similar attributes" means

    __type = wxTYPE_DC_MEMORY;

    device = wxDEVICE_MEMORY;

    // the memory DC is at construction an unusable class because
    // there is no drawable. The initialization will be done with
    // wxMemoryDC::SelectObject(wxBitmap *bitmap)
}

wxMemoryDC::~wxMemoryDC(void)
{
}

//-----------------------------------------------------------------------------
// ask, if a part of the DC is exposed
//-----------------------------------------------------------------------------

int wxMemoryDC::IsExposed(float WXUNUSED(x), float WXUNUSED(y))
{
    return wxEXPOSED_FULL; // always has to be redrawn completely
}

int wxMemoryDC::IsExposed(float WXUNUSED(x), float WXUNUSED(y),
			  float WXUNUSED(w), float WXUNUSED(h))
{
    return wxEXPOSED_FULL; // always has to be redrawn completely
}

//-----------------------------------------------------------------------------
// select bitmap to draw in
//-----------------------------------------------------------------------------

void wxMemoryDC::SelectObject(wxBitmap *bitmap)
{
    // free all associated GCs
    Destroy();

    if (bitmap && bitmap->Ok()) {
	// The bitmap must use the display and screen of the application.
	// The drawable is the associated pixmap, width, height and depth
	// will be queried with XGetGeometry.
	Initialize(wxAPP_DISPLAY, wxAPP_SCREEN, bitmap->GetPixmap());
	ok = TRUE;
	// If another colourmap is associated with the bitmap,
	//  use it instead of the current colourmap.
	if (bitmap->GetColourMap() != current_cmap)
	    SetColourMap(bitmap->GetColourMap());
    } else {
	DrawArea() = 0;
	ok = FALSE;
	Width() = Height() = 0;
    }
}
