/*								-*- C++ -*-
 * $Id: WIN_menubar.cpp,v 1.1 1996-09-25 11:32:21+02 mho Exp $
 *
 * Purpose: menu bar class
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "WIN_menubar.h"
#endif

#define  Uses_XtIntrinsic
#define  Uses_wxMenuBar
#include "wx.h"
#define  Uses_EnforcerWidget
#define  Uses_MenuWidget
#include <widgets.h>

#include <string.h>

// function defined in Menu.cpp
extern char* wxGetLabelAndKey(char *label, char **clean_label, char **clean_key);

//-----------------------------------------------------------------------------
// constructor and destructor
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxMenuBar, wxItem)

wxMenuBar::wxMenuBar(void) : wxItem()
{
    __type = wxTYPE_MENU_BAR;

    top = topdummy = help = last = 0;
    target = NULL;
    // if a title is associated with a menu, it may not be removed
    Append(NULL, NULL); // to have something if associated to frame
    topdummy = top;
}

wxMenuBar::wxMenuBar(int n, wxMenu *menus[], char *titles[]) : wxItem()
{
    __type = wxTYPE_MENU_BAR;

    top = topdummy = help = last = 0;
    target = NULL;
    // if a title is associated with a menu, it may not be removed
    if (n) {
	for (int i=0; i<n; ++i)
	    Append(menus[i], titles[i]);
    } else {
	Append(NULL, NULL); // to have something if associated to frame
	topdummy = top;
    }
}

wxMenuBar::~wxMenuBar(void)
{
    menu_item *item = (menu_item*)top;

    while (item) {
	menu_item *temp = item;
	item = item->next;
	if (temp->contents) {			 // has submenu?
	    if (temp->label != wxEmptyString)
		XtFree(temp->label);             // delete label
	    delete ((wxMenu*)(temp->user_data)); // delete wxMenu
	}
	XtFree((char*)temp);			 // delete menu_item
    }
    target = NULL;
}

//-----------------------------------------------------------------------------
// create and destroy menubar
//-----------------------------------------------------------------------------

Bool wxMenuBar::Create(wxPanel *panel, long style)
{
    ChainToPanel(panel, style, "menubar"); target = panel;

    // create menu widgets
    HWidget() = FWidget() = XtVaCreateManagedWidget
	("menubar", xfwfMenuWidgetClass, GetParentWidget(panel),
	 XtNbackground,  bg.GetPixel(&cmap),
	 XtNforeground,  fg.GetPixel(&cmap),
	 XtNhMargin,     4,
	 XtNfont,        font.GetInternalFont(),
	 XtNmenu,        top,
	 XtNreturnFocus, (panel->PWidget() ? panel->PWidget() : panel->HWidget()),
	 NULL);
    // callbacks
    XtAddCallback(HWidget(), XtNonSelect, wxMenuBar::CommandEventCallback, this);
    XtAddCallback(HWidget(), XtNonChange, wxMenuBar::SelectEventCallback, this);
    // add event handler
    AddEventHandlers();

    return TRUE;
}

void wxMenuBar::Destroy(void)
{
    if (parent)     parent->RemoveChild(this);
    if (FWidget())  XtDestroyWidget(FWidget());
    target = NULL;
    parent = NULL;
    FWidget() = HWidget() = 0;
}

//-----------------------------------------------------------------------------
// add items to menu
//-----------------------------------------------------------------------------

void wxMenuBar::Append(wxMenu *menu, char *title)
{
    if (!menu || !title || menu->owner) // I need menu and title
	return;

    menu_item *item = 0, *pushright = 0;
    // create new menu item or use topdummy
    if (topdummy) {
	item = (menu_item*)topdummy;
	if (item->label != wxEmptyString)
	    XtFree(item->label);
	topdummy = 0;
    } else {
	item = XtNew(menu_item);
    }
    // initialize menu_item
    item->underline = wxGetLabelAndKey(title, &item->label, &item->key_binding);
    item->help_text = NULL;
    item->ID        = -1; 
    item->enabled   = TRUE;
    item->set       = FALSE;
    item->contents  = (menu_item*)menu->top;
    item->next      = NULL;
    item->user_data = (void*)menu;
    item->type      = MENU_CASCADE;
    menu->owner     = (wxMenuItem **)&item->contents; /* MATTHEW */
    // right justified help menu (insert pushright item)
    if (strcmp(item->label, wxSTR_MENU_HELP) == 0) {
	pushright = XtNew(menu_item);
	pushright->type = MENU_PUSHRIGHT;
	pushright->next = item;
	// init unused data
	pushright->label     = NULL;  pushright->underline = NULL; pushright->key_binding = NULL;
	pushright->help_text = NULL;  pushright->ID        = -1;   pushright->enabled     = TRUE;
	pushright->set       = FALSE; pushright->contents  = NULL; pushright->user_data = NULL;
    }
    // chain or initialize menu_item list
    if (last) {
	menu_item *prev = (menu_item*)last;
	prev->next = (pushright ? pushright : item);
	last = (wxMenuItem*)item;
    } else {
	top  = (wxMenuItem*)(pushright ? pushright : item);
	last = (wxMenuItem*)item;
    }
    if (HWidget()) // redisplay if menu added
	XfwfSetMenu(HWidget(), (menu_item*)top, False);
}

void wxMenuBar::Delete(wxMenu *menu, int pos)
{
    menu_item *i, *prev, *prevprev, *pushright;
    int counter;

    pushright = prevprev = prev = NULL;
    for (i = (menu_item *)top, counter = 0;
         i && ((menu && (i->user_data != (void *)menu)) || (!menu && (counter < pos)));
	 ++counter)
    {
	prevprev = prev;
	prev = i;
	i = i->next;
    }
    if (i) {
	// skip pushright item (used for help menu)
	if (prev->type == MENU_PUSHRIGHT) {
	    pushright = prev;
	    prev = prevprev;
	}
	// keep top item
	if (i == (menu_item *)top)
	    top = (wxMenuItem *)i->next;
	// keep last item
	if (i == (menu_item *)last)
	    last = (wxMenuItem *)prev;
	// chain remaining queue
	if (prev)
	    prev->next = i->next;
	// free menubar label
	if (i->contents) {
	    if (i->label != wxEmptyString)
		XtFree(i->label);
	    /* Release menu: */
	    ((wxMenu *)(i->user_data))->owner = NULL;
	}
	// free menubar menu_item
	XtFree((char*)i);
	// free pushright item
	if (pushright) XtFree((char*)pushright);
	// redisplay menu
	if (HWidget())
	    XfwfSetMenu(HWidget(), (menu_item*)top, False);
    }
}

//-----------------------------------------------------------------------------
// modify items
//-----------------------------------------------------------------------------

void wxMenuBar::Check(int id, Bool flag)
{
    menu_item *found = (menu_item*)FindItemForId(id);
    if (found)
	found->set = flag;
}

Bool wxMenuBar::Checked(int id)
{
    menu_item *found = (menu_item*)FindItemForId(id);
    if (found)
	return found->set;
    return FALSE;
}

void wxMenuBar::Enable(int id, Bool flag)
{
    menu_item *found = (menu_item*)FindItemForId(id);
    if (found)
	found->enabled = flag;
}

void wxMenuBar::EnableTop(int pos, Bool flag)
{
    menu_item *item = (menu_item*)top;

    for (int i=0; item && i<pos; ++i)
	item = item->next;
    if (item) {
	item->enabled = flag;
	if (HWidget()) // redisplay if menu added
	    XfwfSetMenu(HWidget(), (menu_item*)top, False);
    }
}

char *wxMenuBar::GetHelpString(int id)
{
    menu_item *found = (menu_item*)FindItemForId(id);
    if (found)
	return found->help_text;
    return NULL;
}

char *wxMenuBar::GetLabel(int id)
{
    menu_item *found = (menu_item*)FindItemForId(id);
    if (found)
	return found->label;
    return NULL;
}

char *wxMenuBar::GetLabelTop(int pos)
{
    menu_item *item = (menu_item*)top;

    for (int i=0; item && i<pos; ++i)
	item = item->next;
    if (item)
	return item->label;
    return NULL;
}

void wxMenuBar::SetHelpString(int id, char *help)
{
    menu_item *found = (menu_item*)FindItemForId(id);
    if (found)
	found->help_text = help;
}

void wxMenuBar::SetLabel(int id, char *label)
{
    menu_item *found = (menu_item*)FindItemForId(id);
    if (found) {
	if (found->label != wxEmptyString) XtFree(found->label);
	found->underline = wxGetLabelAndKey(label, &found->label, &found->key_binding);
    }
}

void wxMenuBar::SetLabelTop(int pos, char *label)
{
    menu_item *item = (menu_item*)top;

    for (int i=0; item && i<pos; ++i)
	item = item->next;
    if (item) {
	if (item->label != wxEmptyString) XtFree(item->label);
	item->underline = wxGetLabelAndKey(label, &item->label, &item->key_binding);
	if (HWidget()) // redisplay if menu added
	    XfwfSetMenu(HWidget(), (menu_item*)top, False);
    }
}

//-----------------------------------------------------------------------------
// handle hotkey
//-----------------------------------------------------------------------------

Bool wxMenuBar::OnHotKey(wxKeyEvent& event)
{
    Bool    handled = FALSE;
    XEvent* xev     = (XEvent*)event.eventHandle;

    if (xev->type == KeyPress && HWidget())
	handled = XfwfHandleHotKey(HWidget(), (XKeyEvent*)(&(xev->xkey)));

    return handled;
}

//-----------------------------------------------------------------------------
// find items by ID or by label
//-----------------------------------------------------------------------------

int wxMenuBar::FindMenuItem(char *menu, char *itemstring)
{
    char *label, *key;
    int  answer = -1;

    wxGetLabelAndKey(menu, &label, &key);

    for (menu_item *item = (menu_item*)top; item; item=item->next)
	if (!strcmp(label, menu) && item->contents) {
	    answer = ((wxMenu*)item->user_data)->FindItem(itemstring);
	    break;
	}
    if (label != wxEmptyString) XtFree(label); // key is part of label
    return answer;
}

wxMenuItem *wxMenuBar::FindItemForId(int id, wxMenu **req_menu)
{
    menu_item *answer=NULL;

    for (menu_item *item = (menu_item*)top; item; item=item->next) {
	if (item->contents)
	    if ((answer = (menu_item*)((wxMenu*)item->user_data)->FindItemForId(id)))
		break; // found
    }
    if (req_menu)
	*req_menu = (wxMenu*)answer->user_data;
    return ((wxMenuItem*)answer);
}

//-----------------------------------------------------------------------------
// callbacks for wxMenuBar
//-----------------------------------------------------------------------------

void wxMenuBar::CommandEventCallback(Widget WXUNUSED(w),
				     XtPointer dclient, XtPointer dcall)
{
    wxMenuBar *menu  = (wxMenuBar*)dclient;
    menu_item *item  = (menu_item*)dcall;

    if (item->type == MENU_TOGGLE)
	item->set = (!item->set);

    // call OnMenuCommandt of target (usually of a frame)
    if (menu->target)
	menu->target->GetEventHandler()->OnMenuCommand(item->ID);
}

void wxMenuBar::SelectEventCallback(Widget WXUNUSED(w),
				    XtPointer dclient, XtPointer dcall)
{
    wxMenuBar *menu  = (wxMenuBar*)dclient;
    menu_item *item  = (menu_item*)dcall;

    // call OnMenuSelect of target (usually of a frame)
    if (menu->target)
	menu->target->GetEventHandler()->OnMenuSelect(item->ID);
}
