
static char rcsid[] = "@(#)$Id: hdrconfg.c,v 1.6 1999/05/10 18:18:34 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.6 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/**   This file contains the routines necessary to be able to modify
      the mail headers of messages on the way off the machine.  The
      headers currently supported for modification are:

	Subject:
	To:
	Cc:
	Bcc:
	Reply-To:
	Expires:
	Priority:
	Precedence:
	In-Reply-To:
	Action:

	<user defined>
**/

#include "headers.h"
#include "s_elm.h"
#include "me.h"

/*
 * Placement of prompts and messages at the bottom of the screen.
 */
#define INSTRUCT_LINE           (elm_LINES-4)
#define INPUT_LINE		(elm_LINES-2)
#define ERROR_LINE		(elm_LINES-1)
#define TOPMOST_PROMPTAREA_LINE INSTRUCT_LINE

/*
 * Option flags for the fields in a (struct hdr_menu_item).
 */
#define HF_DISP_1ROW	0001	/* field is displayed on one line	*/
#define HF_DISP_2ROW	0002	/* field display spans two lines	*/
#define HF_DISP_3ROW	0003	/* field display spans three lines	*/
#define HF_DISP_LEFT	0004	/* field occupies left half of a line	*/
#define HF_DISP_RIGHT	0005	/* field occupies right half of a line	*/
#define HF_DISP_MASK	0007	/* -- mask to pull out display option	*/
#define HF_PROMPT_EXP	0010	/* prompt for expires data entry	*/
#define HF_PROMPT_USR	0020	/* prompt for user defined hdr entry	*/
#define HF_PROMPT_MASK	0070	/* -- mask to pull out prompt option	*/
#define HF_APPENDENTRY	0100	/* append user entry to existing value	*/

struct hdr_menu_item;
typedef void inpval_proc_t P_((struct hdr_menu_item *h,
			     struct mailing_headers *headers,
			     char **ptr, int *size));
typedef char * expval_proc_t P_((struct hdr_menu_item *h,
			       struct mailing_headers *headers));
typedef int hdrproc_t  P_((struct hdr_menu_item *h,
			 struct mailing_headers *headers,
			 char *ptr, int free_only));

/*
 * Structure to describe a header which can be edited in this menu.
 */
struct hdr_menu_item {
    int menucmd;       /* The single keystroke (lower-case letter) the	*
			*   user strikes to edit this menu item.	*/

    char *hdrname;	/* Header name to display in the menu.  Parens	*
			 *   should be used to bracket the "menucmd"	*
			 *   char in the name, e.g. "S)ubject".  This	*
			 *   will be NULL for the user-defined header.	*/

    int lineno;		/* Screen line at which the field is displayed.	*/

    int flags;		/* Various flags which effect the display and	*
			 *   user entry of this item.			*/

    inpval_proc_t *inpval_proc;  
                        /* Returns pointer to the buffer to hold the    *
                         *  value entered by the user. Needs to be      *
                         * dealloced with hdrproc			*/

    expval_proc_t *expval_proc;  
                        /* Returns to tointer to the expanded header    *
			 * value to display.  Returned valued need to   *
			 * be free()ed.                                 */

    hdrproc_t *hdrproc;	/* Pointer to a procedure which verifies the	*
			 *   user data entry, and if required converts	*
			 *   the "inpval" value to "expval" value. Does *
                         * needed deallocation of buffer returned by    *
                         * inpval_proc                                  */
};

/*
 * Local procedures.
 */
static void hdrmenu_clear_promptarea P_((void));
static int hdrmenu_get P_((struct hdr_menu_item *h,
			   struct mailing_headers *headers));
static void hdrmenu_put P_((struct hdr_menu_item *h,
			    int already_clear,
			    struct mailing_headers *headers));

/* To: -header -------------------------------------------------------- */

static void inpval_to P_((struct hdr_menu_item *h,
			  struct mailing_headers *headers,
			  char **ptr, int *size));
static char * expval_to P_((struct hdr_menu_item *h,
			    struct mailing_headers *headers));
static int hdrproc_to  P_((struct hdr_menu_item *h,
			   struct mailing_headers *headers,
			   char *ptr, int free_only));

/* CC: -header -------------------------------------------------------- */

static void inpval_cc P_((struct hdr_menu_item *h,
			  struct mailing_headers *headers,
			  char **ptr, int *size));
static char * expval_cc P_((struct hdr_menu_item *h,
			    struct mailing_headers *headers));
static int hdrproc_cc  P_((struct hdr_menu_item *h,
			   struct mailing_headers *headers,
			   char *ptr, int free_only));

/* BCC: -header -------------------------------------------------------- */

static void inpval_bcc P_((struct hdr_menu_item *h,
			   struct mailing_headers *headers,
			   char **ptr, int *size));
static char * expval_bcc P_((struct hdr_menu_item *h,
			     struct mailing_headers *headers));
static int hdrproc_bcc  P_((struct hdr_menu_item *h,
			    struct mailing_headers *headers,
			    char *ptr, int free_only));


/* Subject: -header -------------------------------------------------------- */

static void inpval_subject P_((struct hdr_menu_item *h,
			       struct mailing_headers *headers,
			       char **ptr, int *size));
static char * expval_subject P_((struct hdr_menu_item *h,
				 struct mailing_headers *headers));
static int hdrproc_subject  P_((struct hdr_menu_item *h,
				struct mailing_headers *headers,
				char *ptr, int free_only));


/* Reply-To: -header -------------------------------------------------- */

static void inpval_reply_to P_((struct hdr_menu_item *h,
				struct mailing_headers *headers,
				char **ptr, int *size));
static char * expval_reply_to P_((struct hdr_menu_item *h,
				  struct mailing_headers *headers));
static int hdrproc_reply_to  P_((struct hdr_menu_item *h,
				 struct mailing_headers *headers,
				 char *ptr, int free_only));


/* Action: -header ---------------------------------------------------- */

static void inpval_action P_((struct hdr_menu_item *h,
			      struct mailing_headers *headers,
			      char **ptr, int *size));
static char * expval_action P_((struct hdr_menu_item *h,
				struct mailing_headers *headers));
static int hdrproc_action  P_((struct hdr_menu_item *h,
			       struct mailing_headers *headers,
			       char *ptr, int free_only));

/* Expires: -header ---------------------------------------------------- */

static void inpval_expires P_((struct hdr_menu_item *h,
			       struct mailing_headers *headers,
			       char **ptr, int *size));
static char * expval_expires P_((struct hdr_menu_item *h,
				 struct mailing_headers *headers));
static int hdrproc_expires  P_((struct hdr_menu_item *h,
				struct mailing_headers *headers,
				char *ptr, int free_only));


/* Priority: -header ---------------------------------------------------- */

static void inpval_priority P_((struct hdr_menu_item *h,
				struct mailing_headers *headers,
				char **ptr, int *size));
static char * expval_priority P_((struct hdr_menu_item *h,
				  struct mailing_headers *headers));
static int hdrproc_priority  P_((struct hdr_menu_item *h,
				 struct mailing_headers *headers,
				 char *ptr, int free_only));

/* Precedence: -header ---------------------------------------------------- */

static void inpval_precedence P_((struct hdr_menu_item *h,
				  struct mailing_headers *headers,
				  char **ptr, int *size));
static char * expval_precedence P_((struct hdr_menu_item *h,
				    struct mailing_headers *headers));
static int hdrproc_precedence  P_((struct hdr_menu_item *h,
				   struct mailing_headers *headers,
				 char *ptr, int free_only));

/* In-Reply-To: -header ---------------------------------------------------- */

static void inpval_in_reply_to P_((struct hdr_menu_item *h,
				   struct mailing_headers *headers,
				   char **ptr, int *size));
static char * expval_in_reply_to P_((struct hdr_menu_item *h,
				     struct mailing_headers *headers));
static int hdrproc_in_reply_to  P_((struct hdr_menu_item *h,
				    struct mailing_headers *headers,
				    char *ptr, int free_only));

/* User defined header ---------------------------------------------------- */

static void inpval_userhdr P_((struct hdr_menu_item *h,
			       struct mailing_headers *headers,
			       char **ptr, int *size));
static char * expval_userhdr P_((struct hdr_menu_item *h,
				 struct mailing_headers *headers));
static int hdrproc_userhdr  P_((struct hdr_menu_item *h,
				struct mailing_headers *headers,
				char *ptr, int free_only));

/*
 * Definition of all the header editing menu fields.
 */
struct hdr_menu_item hmenu_item_list[] = {
    { 't', "T)o",		 2, HF_DISP_3ROW|HF_APPENDENTRY,
      inpval_to, expval_to, hdrproc_to },
    { 'c', "C)c",		 5, HF_DISP_3ROW|HF_APPENDENTRY,
      inpval_cc, expval_cc, hdrproc_cc },
    { 'b', "B)cc",		 8, HF_DISP_2ROW|HF_APPENDENTRY,
      inpval_bcc, expval_bcc, hdrproc_bcc },
    { 's', "S)ubject",		10, HF_DISP_2ROW, 
      inpval_subject, expval_subject, hdrproc_subject },
    { 'r', "R)eply-to",		12, HF_DISP_1ROW, 
      inpval_reply_to, expval_reply_to, hdrproc_reply_to },
    { 'a', "A)ction",		13, HF_DISP_LEFT, 
      inpval_action, expval_action, hdrproc_action },
    { 'e', "E)xpires",		13, HF_DISP_RIGHT|HF_PROMPT_EXP, 
      inpval_expires, expval_expires, hdrproc_expires },
    { 'p', "P)riority",		14, HF_DISP_LEFT, 
      inpval_priority, expval_priority, hdrproc_priority },

    { 'n', "Precede(n)ce",	14, HF_DISP_RIGHT, 
      inpval_precedence, expval_precedence, hdrproc_precedence },

    { 'i', "I)n-reply-to",	15, HF_DISP_2ROW,
      inpval_in_reply_to, expval_in_reply_to, hdrproc_in_reply_to },

    { 'u', NULL,		17, HF_DISP_1ROW|HF_PROMPT_USR,
      inpval_userhdr, expval_userhdr, hdrproc_userhdr },
    { -1, NULL, -1, -1, NULL, NULL, NULL },
};

/*
 * Selection of individual fields.  The indices *must* correspond
 * to the above "hmenu_item_list[]" list.
 */
#define hmenu_to		(hmenu_item_list[0])
#define hmenu_cc		(hmenu_item_list[1])
#define hmenu_bcc		(hmenu_item_list[2])
#define hmenu_subject		(hmenu_item_list[3])
#define hmenu_replyto		(hmenu_item_list[4])
#define hmenu_action		(hmenu_item_list[5])
#define hmenu_expires		(hmenu_item_list[6])
#define hmenu_priority		(hmenu_item_list[7])
#define hmenu_precedence	(hmenu_item_list[8])
#define hmenu_inreplyto		(hmenu_item_list[9])
#define hmenu_userdef		(hmenu_item_list[10])


void edit_headers(headers)
     struct mailing_headers *headers;    
{
    int c, i, do_redraw;
    struct hdr_menu_item *h;
    int precmd = 0;
    
    /* expand out all of the header values */
    /* menu displays expanded values, user edits unexpended versions */

redraw:
    do_redraw = TRUE;
    while (TRUE) {	/* forever */

	/* redraw the entire display if required */
	if (do_redraw) {
	    ClearScreen();
	    Centerline(0, catgets(elm_msg_cat, ElmSet,
		ElmHdrmenuScreenTitle, "Message Header Edit Screen"));
	    for (h = hmenu_item_list ; h->menucmd > 0 ; ++h)
		hdrmenu_put(h, TRUE, headers);
	    do_redraw = FALSE;
	}

	/* display the instructions */
#ifdef ALLOW_SUBSHELL
	Centerline(INSTRUCT_LINE, catgets(elm_msg_cat, ElmSet,
	    ElmHdrmenuInstruct,
	    "Choose header, u)ser defined header, !)shell, or <return>."));
#else
	Centerline(INSTRUCT_LINE, catgets(elm_msg_cat, ElmSet,
	    ElmHdrmenuInstructNoShell,
	    "Choose header, u)ser defined header, or <return>."));
#endif

	/* prompt for command */
	PutLine0(INPUT_LINE, 0, catgets(elm_msg_cat, ElmSet,
	    ElmHdrmenuPrompt, "Choice: "));
	if (precmd) {
	  c = precmd;
	  precmd = 0;
	} else {
	  c = ReadCh(REDRAW_MARK);
	  if (c == REDRAW_MARK) {
	    do_redraw = TRUE;
	    continue;
	  }
	}

#ifdef ASCII_CTYPE
	if (isascii(c))
#endif
	  c = tolower(c);
	hdrmenu_clear_promptarea();

	/* execute the command */
	switch (c) {

	case EOF:
	case RETURN:
	case LINE_FEED:
	case 'q':
	    return;

#ifdef ALLOW_SUBSHELL
	case '!':
	    if (subshell())
		do_redraw = TRUE;
	    break;
#endif

	case ctrl('L'):
	    do_redraw = TRUE;
	    break;
    
	default:
	    for (h = hmenu_item_list ; h->menucmd > 0 ; ++h) {
		if (h->menucmd == c) {
		    int status = hdrmenu_get(h,headers);
		    if (REDRAW_MARK == status) {
			precmd = c;
			do_redraw = TRUE;
			break;
		    }

		    if (status != 0) {
			Writechar('\007');
			break;
		    }
		    hdrmenu_put(h, FALSE,headers);
		    break;
		}
	    }
	    if (h->menucmd <= 0) {
		Centerline(ERROR_LINE, catgets(elm_msg_cat, ElmSet,
		    ElmHdrmenuBadChoice, "No such header!"));
		Writechar('\007');
	    }
	    break;

	}

    }

    /*NOTREACHED*/
}


/*
 * Erase instructions, user input, left-over errors, etc.
 * This should be run after every user input command in this module.
 */
static void hdrmenu_clear_promptarea()
{
    clear_error();
    MoveCursor(TOPMOST_PROMPTAREA_LINE, 0);
    CleartoEOS();
}


/*
 * Prompt the user for a header value, and do any required post-processing.
 */
static int hdrmenu_get(h,headers)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;  
{
    char *s;
    int plen, ret, do_append;
    char *buffer = NULL;
    int size = 0;

    /* display the instructions */
    switch (h->flags & HF_PROMPT_MASK) {
    case HF_PROMPT_EXP:
	Centerline(INSTRUCT_LINE, catgets(elm_msg_cat, ElmSet,
	    ElmHdrmenuGetExpiresInstruct,
	    "In how many days should this message expire? "));
	break;
    case HF_PROMPT_USR:
	Centerline(INSTRUCT_LINE, catgets(elm_msg_cat, ElmSet,
	    ElmHdrmenuGetUserdefInstruct,
	    "Enter in the format \"HeaderName: HeaderValue\"."));
	break;
    default:
	Centerline(INSTRUCT_LINE, catgets(elm_msg_cat, ElmSet,
	    ElmHdrmenuGetInstruct, "Enter value for the header."));
	break;
    }

    /* display a prompt */
    plen = 0;
    if (h->hdrname != NULL) {
	MoveCursor(INPUT_LINE, 0);
	for (s = h->hdrname ; *s != '\0' ; ++s) {
	    if (*s != '(' && *s != ')') {
		Writechar(*s);
		++plen;
	    }
	}
	Writechar(':');
	Writechar(' ');
	plen += 2;
    }

    /* get input from the user */
    do_append = ((h->flags & HF_APPENDENTRY) != 0);
    h->inpval_proc(h,headers,&buffer,&size);

    ret = optionally_enter(buffer, INPUT_LINE, plen, 
			   (do_append ? OE_APPEND_CURRENT : 0) | 
			   OE_REDRAW_MARK, size);
    if (ret == REDRAW_MARK) {
	h->hdrproc(h,headers,buffer,TRUE);
	return REDRAW_MARK;
    }

    hdrmenu_clear_promptarea();

    /* bail out on error */
    if (ret < 0) {
	h->hdrproc(h,headers,buffer,TRUE);
	return -1;
    }
    /* see if there is some processing required on this value */
    return h->hdrproc(h,headers,buffer,FALSE);
}


/*
 * Dispay a header and its value in the appropriate field.
 */
static void hdrmenu_put(h, already_clear, headers)
     struct hdr_menu_item *h;
     int already_clear;
     struct mailing_headers *headers; 
{
    char * buffer = NULL;
    char    *p;
    int     start_row, max_row, start_col, max_col, row, col;

    /* figure out the dimensions of the field */
    switch (h->flags & HF_DISP_MASK) {
    case HF_DISP_LEFT:
	start_row = h->lineno;		max_row = h->lineno;
	start_col = 0;			max_col = elm_COLUMNS/2 - 2;
	break;
    case HF_DISP_RIGHT:
	start_row = h->lineno;		max_row = h->lineno;
	start_col = elm_COLUMNS/2 + 1;	max_col = elm_COLUMNS-1;
	break;
    case HF_DISP_3ROW:
	start_row = h->lineno;		max_row = h->lineno+2;
	start_col = 0;			max_col = elm_COLUMNS-1;
	break;
    case HF_DISP_2ROW:
	start_row = h->lineno;		max_row = h->lineno+1;
	start_col = 0;			max_col = elm_COLUMNS-1;
	break;
    default:
	start_row = h->lineno;		max_row = h->lineno;
	start_col = 0;			max_col = elm_COLUMNS-1;
	break;
    }

    /* display the header name */
    MoveCursor(start_row, start_col);
    if (h->hdrname != NULL) {
	for (p = h->hdrname ; *p != '\0' ; ++p)
	    Writechar(*p);
	Writechar(':');
	Writechar(' ');
    }

    /* display the header value */
    GetXYLocation(&row, &col);

    buffer=h->expval_proc(h,headers);
    
    for (p = buffer ; p && *p != '\0' && row <= max_row ; ++p) {
	if (row == max_row && col == max_col-4 && strlen(p) > 4)
	    p = " ...";		/* neat hack alert */
	Writechar(*p);
	if (!isascii(*p) || !isprint(*p) || ++col > max_col)
	    GetXYLocation(&row, &col);
    }

    /* save some drawing if we know the screen is already empty */
    if (!already_clear) {
	
	/* clear out remaining space in this line of the field */
	if (max_col == elm_COLUMNS-1) {
	    /* people on slow terminals might appreciate doing it this way */
	    CleartoEOLN();
	} else {
	    while (col++ <= max_col)
		Writechar(' ');
	}
	
	/* for multi-line fields, clear out any unused lines */
	/* this assumes that multi-line fields span the entire screen width */
	while (++row <= max_row) {
	    /* grrrrrr -- this is a multi-statement macro */
	    ClearLine(row);
	}

    }
    if (buffer)
	free(buffer);
}

void hdr_to_buffer(addrs,ptr,size)
     struct expanded_address addrs;
     char **ptr; 
     int *size;
{
    int max = LONG_STRING;
    int l = 0;
    struct textual *p;

    /* Estimate space usage */
    for (p = addrs.surface; 
	 p < addrs.surface + addrs.surface_len; 
	 p++) {
	l += 7;
	if (p->textual)
	    l += strlen(p->textual);
    }

    if (max < l)
	max = l+1;

    *ptr = safe_malloc(max);
    *size = max;

    expanded_to_edit_buffer(*ptr,max,addrs);
}

char *hdr_to_expval(addrs)
     struct expanded_address addrs;
{
    struct addr_item *p;
    char * buffer = NULL;
    
    for (p = addrs.addrs; p < addrs.addrs + addrs.addrs_len; p++) {
	if (buffer)
	    buffer = strmcat(buffer,", ");
	if (p->fullname[0] || ! p->addr[0] || '@' == p->addr[0]) {
	    /* We do not quote displayed (only) address */
	    buffer = strmcat(buffer,p->fullname);
	    buffer = strmcat(buffer," <");
	    buffer = strmcat(buffer,p->addr);
	    buffer = strmcat(buffer,">");
	} else
	    buffer = strmcat(buffer,p->addr);
	if (p->comment[0]) {
	    /* We do not quote displayed (only) address */
	    buffer = strmcat(buffer," (");
	    buffer = strmcat(buffer,p->comment);
	    buffer = strmcat(buffer,")");
	}
    } 
    return buffer;
}

/*
 * Process the to, cc, and bcc headers.  The value entered by the
 * user is expanded.  A successful status is always returned.
 */

int buffer_to_header(addrs,ptr,free_only)
     struct expanded_address *addrs;
     char *ptr;
     int free_only;
{
    if (!free_only) {
	update_expanded_from_edit_buffer(addrs,ptr);
    }
    free(ptr);    
    return 0;
}

static void text_to_buffer P_((char *text,char **ptr,int *size));
static void text_to_buffer(text,ptr,size)
     char *text;
     char **ptr;
     int *size; 
{
    int max = STRING;
    int l = 0;

    if (text)
	l = strlen(text);
    if (max < l)
	max = l + 1;

    *ptr = safe_malloc(max);
    *size = max;
    if (text)
	strfcpy(*ptr,text,max);
    else
	(*ptr)[0]='\0';
}

static char *text_to_expval P_((char *text));
static char *text_to_expval(text)
     char *text;
{
    if (!text)
	return safe_strdup("");
    else
	return safe_strdup(text);
}

static int buffer_to_text P_((char **text,char *ptr,int free_only));
static int buffer_to_text(text,ptr,free_only)
     char **text;
     char *ptr;
     int free_only;
{
    if (!free_only)
	*text = strmcpy(*text,ptr);
    free(ptr);
    return 0;
}


/* To: -header -------------------------------------------------------- */

static void inpval_to (h,headers,ptr,size)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char **ptr; 
     int *size;
{
    hdr_to_buffer(headers->to,ptr,size);
}

static char * expval_to (h,headers)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
{
    return hdr_to_expval(headers->to);
}

static int hdrproc_to  (h,headers,ptr,free_only)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char *ptr;
     int free_only;
{
    return buffer_to_header(&headers->to,ptr,free_only);
}

/* CC: -header -------------------------------------------------------- */

static void inpval_cc (h,headers,ptr,size)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char **ptr; 
     int *size;
{
    hdr_to_buffer(headers->cc,ptr,size);
}

static char * expval_cc (h,headers)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
{
    return hdr_to_expval(headers->cc);
}

static int hdrproc_cc  (h,headers,ptr,free_only)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char *ptr;
     int free_only;
{
    return buffer_to_header(&headers->cc,ptr,free_only);
}

/* BCC: -header -------------------------------------------------------- */

static void inpval_bcc (h,headers,ptr,size)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char **ptr; 
     int *size;
{
    hdr_to_buffer(headers->bcc,ptr,size);
}

static char * expval_bcc (h,headers)
     struct hdr_menu_item *h;     
     struct mailing_headers *headers;
{
    return hdr_to_expval(headers->bcc);
}

static int hdrproc_bcc  (h,headers,ptr,free_only)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char *ptr;
     int free_only;
{
    return buffer_to_header(&headers->bcc,ptr,free_only);
}

/* Subject: -header -------------------------------------------------------- */

static void inpval_subject (h,headers,ptr,size)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char **ptr; 
     int *size;
{
    text_to_buffer(headers->subject,ptr,size); 
}

static char * expval_subject (h,headers)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
{
    return text_to_expval(headers->subject);
}

static int hdrproc_subject  (h,headers,ptr,free_only)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char *ptr; 
     int free_only;
{
    return buffer_to_text(&headers->subject,ptr,free_only);
}

/* Reply-To: -header -------------------------------------------------- */

static void inpval_reply_to (h,headers,ptr,size)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char **ptr;
     int *size;
{
    hdr_to_buffer(headers->reply_to,ptr,size);
}

static char * expval_reply_to (h,headers)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
{
    return hdr_to_expval(headers->reply_to);
}

static int hdrproc_reply_to  (h,headers,ptr,free_only)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char *ptr; 
     int free_only;
{
    return buffer_to_header(&headers->reply_to,ptr,free_only);
}

/* Action: -header ---------------------------------------------------- */

static void inpval_action (h,headers,ptr,size)
     struct hdr_menu_item *h;     
     struct mailing_headers *headers;
     char **ptr; 
     int *size;
{
    text_to_buffer(headers->action,ptr,size); 
}

static char * expval_action (h,headers)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
{
    return text_to_expval(headers->action);
}

static int hdrproc_action  (h,headers,ptr,free_only)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char *ptr; 
     int free_only;
{
    return buffer_to_text(&headers->action,ptr,free_only);
}

/* Expires: -header ---------------------------------------------------- */

static void inpval_expires (h,headers,ptr,size)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char **ptr; 
     int *size;
{
    text_to_buffer(headers->expires_days,ptr,size); 
}

static char * expval_expires (h,headers)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
{
    return text_to_expval(headers->expires);
}

/*
 * Process the expires header.  The value entered by the user is interpreted
 * as a number of days, and is expanded out to a date specification.  If
 * an error occurs a message is printed, the expanded value is cleared
 * out, and a -1 is returned.
 */

static int hdrproc_expires  (h,headers,ptr,free_only)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char *ptr; 
     int free_only;
{
    int ret_val = 0;
    if (!free_only) {
	char buffer[STRING];
	int days;

	/* initialize expanded date spec to empty */
	if (headers->expires)
	    free(headers->expires);
	headers->expires = NULL;

	/* blank is ok */
	if (ptr[0] == '\0') {
	    if (headers->expires_days)
		free(headers->expires_days);
	    headers->expires_days = NULL;
	    goto free_it;
	}

	/* verify the number of days is valid and in range */
	days = atoi(ptr);
	if (days < 1) {
	    Centerline(ERROR_LINE, 
		       catgets(elm_msg_cat, ElmSet,
			       ElmHdrmenuExpiresNotNumber,
			       "Expiration must be specified as a number of days."));
	    ret_val = -1;
	    goto free_it;
	}	

	if (days > 8*7) {
	    Centerline(ERROR_LINE, catgets(elm_msg_cat, ElmSet,
					   ElmHdrmenuExpiresOutOfRange,
					   "Expiration date must be within eight weeks of today."));
	    ret_val = -1;
	    goto free_it;
	}
	/* convert number of days to a date */
	days_ahead(days, buffer, sizeof buffer);

	headers->expires = strmcpy(headers->expires,buffer);
	headers->expires_days = strmcpy(headers->expires_days,ptr);
	ret_val = 0;
    }

 free_it:
    free(ptr);
    return ret_val;
}


/* Priority: -header ---------------------------------------------------- */

static void inpval_priority (h,headers,ptr,size)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char **ptr; 
     int *size;
{
    text_to_buffer(headers->priority,ptr,size); 
}

static char * expval_priority (h,headers)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
{
    return text_to_expval(headers->priority);
}

static int hdrproc_priority  (h,headers,ptr,free_only)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char *ptr;
     int free_only;
{
    return buffer_to_text(&headers->priority,ptr,free_only);
}

/* Precedence: -header ---------------------------------------------------- */

static void inpval_precedence (h,headers,ptr,size)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char **ptr; int *size;
{
    text_to_buffer(headers->precedence,ptr,size); 
}

static char * expval_precedence (h,headers)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
{
    return text_to_expval(headers->precedence);
}

/*
 * Process the precedence header.  The value entered by the user is
 * checked against the list of allowed precedences, if one exists.  If
 * the precedence has a priority assigned to it, then an empty priority
 * field will be filled in with that value.  If an error occurs a message
 * is printed, the precedence value is cleared out, and a -1 is returned.
 */

static int hdrproc_precedence  (h,headers,ptr,free_only)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char *ptr; 
     int free_only;
{
    int ret_val = 0;

    if (!free_only) {
	char *buf, *bp;
	char *prec = NULL, *prio = NULL;

	/* empty is ok */
	if (ptr[0] == '\0') {
	    if (headers->precedence)
		free(headers->precedence);
	    headers->precedence = NULL;
	    goto free_it;
	}

	/* if there are no restrictions on precedence then anything is ok */
	if (allowed_precedences[0] == '\0') {
	    headers->precedence = strmcpy(headers->precedence,ptr);
	    goto free_it;
	}

	/* the "allowed_precedences[]" format is: */
	/*   precedence[:priority-value] precedence[:priority-value] ... */
	bp = buf = safe_strdup(allowed_precedences);

	while ((prec = strtok(bp, " \t\n")) != NULL) {
	    bp = NULL;
	    if ((prio = index(prec, ':')) != NULL)
		*prio++ = '\0';
	    if (istrcmp(prec, ptr) == 0)
		break;
	}
	free(buf);

	/* see if we reached the end of the list without a match */
	if (prec == NULL) {
	    Centerline(ERROR_LINE, 
		       catgets(elm_msg_cat, ElmSet,
			       ElmHdrmenuPrecedenceBadValue,
			       "Unknown precedence value specified."));	    
	    ret_val = -1;
	    goto free_it;
	}

	headers->precedence = strmcpy(headers->precedence,ptr);

	/* see if this precedence has an associated priority */
	if (prio != NULL && headers->priority == NULL) {
	    headers->priority = strmcpy(headers->priority,prio);
	    hdrmenu_put(&hmenu_priority, FALSE,headers);
	}
	ret_val = 0;

    }

 free_it:
    free(ptr);
    return ret_val;
}

/* In-Reply-To: -header ---------------------------------------------------- */

static void inpval_in_reply_to (h,headers,ptr,size)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char **ptr;
     int *size;
{
    text_to_buffer(headers->in_reply_to,ptr,size);
}

static char * expval_in_reply_to (h,headers)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
{
    return text_to_expval(headers->in_reply_to);
}

static int hdrproc_in_reply_to  (h,headers,ptr,free_only)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char *ptr; 
     int free_only;
{
    return buffer_to_text(&headers->in_reply_to,ptr,free_only);
}

/* User defined header ---------------------------------------------------- */

static void inpval_userhdr (h,headers,ptr,size)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char **ptr; int *size;
{
    text_to_buffer(headers->user_defined_header,ptr,size);
}

static char * expval_userhdr (h,headers)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
{
    return text_to_expval(headers->user_defined_header);
}

/*
 * Process the user-defined header.  The value entered by the user is
 * verified for proper format.  If an error occurs a message is printed,
 * the expanded value is cleared out, and a -1 is returned.
 */

static int hdrproc_userhdr  (h,headers,ptr,free_only)
     struct hdr_menu_item *h;
     struct mailing_headers *headers;
     char *ptr; 
     int free_only;
{
    int ret_val = 0;

    if (!free_only) {
	char *s;

	/* empty is ok */
	if (!ptr[0]) {
	    if (headers->user_defined_header)
		free(headers->user_defined_header);
	    headers->user_defined_header = NULL;
	    goto free_it;
	}

	
	/* make sure the header name doesn't begin with some strange 
	 * character -- Note that only US-ASCII is allowed according
	 * of standards on headers
	 */

	if (!isascii(ptr[0]) &&
	    !isalnum(ptr[0])) {
	    Centerline(ERROR_LINE, 
		       catgets(elm_msg_cat, ElmSet,
			       ElmHdrmenuUserdefNotAlnum,
			       "The user-defined header must begin with a letter or number."));
	    ret_val = -1;
	    goto free_it;
	}
	
	/* locate the end of the header name */
	for (s = ptr ; 
	     *s != ':' && isascii(*s) && isprint(*s) && !isspace(*s) ; 
	     ++s)
	    continue;
	
	    /* there needs to be a colon at the end of the header name */
	if (*s != ':') {
	    Centerline(ERROR_LINE, 
		       catgets(elm_msg_cat, ElmSet,
			       ElmHdrmenuUserdefMissingColon,
			       "The user-defined header must have a colon after the field name."));
	    ret_val = -1;
	    goto free_it;
	}
	
	headers->user_defined_header = strmcpy(headers->user_defined_header,
					       ptr);
	ret_val = 0;
    }

 free_it:
    free(ptr);
    return ret_val;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */

