/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef cercle_h
#define cercle_h

#include <string.h>
#include <libintl.h>
#include <math.h>

#include "classbase.h"
#include "complexe.h"
#include "mode_obj.h"
#include "graphic.h"
#include "traite.h"

// Class derived from the base class cercle_c
// Class 'cercle1', circle defined by its center and a point on the circle
class cercle1:public cercle_c
{
  public:
  point_c * A;			// a point on the circle

  cercle1 ():cercle_c ()
  {
    classe = CE_2PT;
  }
  cercle1 (liste_elem & lp):cercle_c ()
  {
    A = (point_c *) lp.lire (2);
    C = (point_c *) lp.lire (1);
    classe = CE_2PT;
    init_nom ();
  }
  cercle1 (char a, char b, char c, char d, liste_elem & lp):cercle_c (a, b, c, d)
  {
    A = (point_c *) lp.lire (2);
    C = (point_c *) lp.lire (1);
    classe = CE_2PT;
    init_nom ();
  }
  virtual double rayon ();
  void actualise ();
  void move (int xm, int ym);
  void sauve_disk (FILE * f);
  liste_elem *parents (liste_elem * liste_parent);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// Class 'cercle2', circle defined by its center and radius (given by a segment's length)
class cercle2:public cercle_c
{
  public:
  segment_c * S;		// radius = segment's length

  cercle2 ():cercle_c ()
  {
    classe = CE_SE;
  }
  cercle2 (liste_elem & lp):cercle_c ()
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_POINT)
      {
	C = (point_c *) f1;
	S = (segment_c *) f2;
      }
    else
      {
	C = (point_c *) f2;
	S = (segment_c *) f1;
      }
    classe = CE_SE;
    init_nom ();
  }
  cercle2 (char a, char b, char c, char d, liste_elem & lp):cercle_c (a, b, c, d)
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_POINT)
      {
	C = (point_c *) f1;
	S = (segment_c *) f2;
      }
    else
      {
	C = (point_c *) f2;
	S = (segment_c *) f1;
      }
    classe = CE_SE;
    init_nom ();
  }
  virtual double rayon ();
  void actualise ();
  liste_elem *parents (liste_elem * liste_parent);
  void move (int xm, int ym);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// Class 'cercle3', circle defined by its center and radius (given number)
class cercle3:public cercle_c
{
  public:
  valeur_c * V;			// radius

  cercle3 ():cercle_c ()
  {
    classe = CE_VA;
  }
  cercle3 (liste_elem & lp):cercle_c ()
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_POINT)
      {
	C = (point_c *) f1;
	V = (valeur_c *) f2;
      }
    else
      {
	C = (point_c *) f2;
	V = (valeur_c *) f1;
      }
    classe = CE_VA;
    init_nom ();
  }
  cercle3 (char a, char b, char c, char d, liste_elem & lp):cercle_c (a, b, c, d)
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_POINT)
      {
	C = (point_c *) f1;
	V = (valeur_c *) f2;
      }
    else
      {
	C = (point_c *) f2;
	V = (valeur_c *) f1;
      }
    classe = CE_VA;
    init_nom ();
  }
  virtual double rayon ();
  void actualise ();
  liste_elem *parents (liste_elem * liste_parent);
  void move (int xm, int ym);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// Transformed circle
// By reflexion
class reflexion_cercle:public cercle_c
{
  public:
  droite_c * axe;
  cercle_c *cercle;
    reflexion_cercle ():cercle_c ()
  {
    classe = CE_RE;
  }
  reflexion_cercle (liste_elem & lp):cercle_c ()
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_DROITE)
      {
	cercle = (cercle_c *) f2;
	axe = (droite_c *) f1;
      }
    else
      {
	cercle = (cercle_c *) f1;
	axe = (droite_c *) f2;
      }
    actualise ();
    classe = CE_RE;
    init_nom ();
  }
  void actualise (void);
  double rayon (void);
  point_s centre (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By symetry
class symetrie_cercle:public cercle_c
{
  public:
  point_c * symetrie;
  cercle_c *cercle;
    symetrie_cercle ():cercle_c ()
  {
    classe = CE_SY;
  }
  symetrie_cercle (liste_elem & lp):cercle_c ()
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_POINT)
      {
	cercle = (cercle_c *) f2;
	symetrie = (point_c *) f1;
      }
    else
      {
	cercle = (cercle_c *) f1;
	symetrie = (point_c *) f2;
      }
    actualise ();
    classe = CE_SY;
    init_nom ();
  }
  void actualise (void);
  double rayon (void);
  point_s centre (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By translation
class translation_cercle:public cercle_c
{
  public:
  vecteur_c * v;
  cercle_c *cercle;
    translation_cercle ():cercle_c ()
  {
    classe = CE_TR;
  }
  translation_cercle (liste_elem & lp):cercle_c ()
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_VECTEUR)
      {
	cercle = (cercle_c *) f2;
	v = (vecteur_c *) f1;
      }
    else
      {
	cercle = (cercle_c *) f1;
	v = (vecteur_c *) f2;
      }
    actualise ();
    classe = CE_TR;
    init_nom ();
  }
  void actualise (void);
  double rayon (void);
  point_s centre (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By rotation
class rotation_cercle:public cercle_c
{
  public:
  valeur_c * v;
  point_c *c;
  cercle_c *cercle;
    rotation_cercle ():cercle_c ()
  {
    classe = CE_RO;
  }
  rotation_cercle (liste_elem & lp):cercle_c ()
  {
    figure_c *f1, *f2, *f3;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    f3 = (figure_c *) lp.lire (3);
    if (f1->type == FIG_POINT)
      {
	c = (point_c *) f1;
	if (f2->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f2;
	    cercle = (cercle_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    cercle = (cercle_c *) f2;
	  }
      }
    else if (f2->type == FIG_POINT)
      {
	c = (point_c *) f2;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    cercle = (cercle_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    cercle = (cercle_c *) f1;
	  }
      }
    else
      {
	c = (point_c *) f3;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    cercle = (cercle_c *) f2;
	  }
	else
	  {
	    v = (valeur_c *) f2;
	    cercle = (cercle_c *) f1;
	  }
      }
    actualise ();
    classe = CE_RO;
    init_nom ();
  }
  void actualise (void);
  double rayon (void);
  point_s centre (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By homothetie
class homothetie_cercle:public cercle_c
{
  public:
  valeur_c * v;
  point_c *c;
  cercle_c *cercle;
    homothetie_cercle ():cercle_c ()
  {
    classe = CE_HO;
  }
  homothetie_cercle (liste_elem & lp):cercle_c ()
  {
    figure_c *f1, *f2, *f3;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    f3 = (figure_c *) lp.lire (3);
    if (f1->type == FIG_POINT)
      {
	c = (point_c *) f1;
	if (f2->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f2;
	    cercle = (cercle_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    cercle = (cercle_c *) f2;
	  }
      }
    else if (f2->type == FIG_POINT)
      {
	c = (point_c *) f2;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    cercle = (cercle_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    cercle = (cercle_c *) f1;
	  }
      }
    else
      {
	c = (point_c *) f3;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    cercle = (cercle_c *) f2;
	  }
	else
	  {
	    v = (valeur_c *) f2;
	    cercle = (cercle_c *) f1;
	  }
      }
    actualise ();
    classe = CE_HO;
    init_nom ();
  }
  void actualise (void);
  double rayon (void);
  point_s centre (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};

#endif
