/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * po_install.c 
 */

/*
 * Create PORBIT postmaster object
 */
#include <stdio.h>

#include "constants.h"
#include "defaults.h"
#include "pm.h"
#include "porbit.h"

static void porbit_reset(void);

static char *PORBIT_OBJ_NAME = "Porbit";

static char *PORBIT[] = {
  "Porbit.Varb", "Porbit.Param", 
  "Porbit.Period", "Porbit.Numsteps",
  "Porbit.Algorithm","Porbit.Value",
  "Porbit.Stepsize", "Porbit.Go",
  "Porbit.Reset"
  };

typedef enum {
  VARB=0, PARAM, PERIOD, NUMSTEPS, ALGORITHM, VALUE, PSTEPSIZE, GO, RESET
  } PORBIT_t;


void
porbit_install()
{
  pm(CREATE_OBJ, PORBIT_OBJ_NAME,
     CREATE_ELEM, PORBIT[VARB], INT,
     CREATE_ELEM, PORBIT[PARAM], INT,
     CREATE_ELEM, PORBIT[PERIOD], INT,
     CREATE_ELEM, PORBIT[NUMSTEPS], INT,
     CREATE_ELEM, PORBIT[ALGORITHM], INT,
     CREATE_ELEM, PORBIT[VALUE], DBL,
     CREATE_ELEM, PORBIT[PSTEPSIZE], DBL,
     CREATE_ELEM, PORBIT[GO], FNCT, 
     CREATE_ELEM, PORBIT[RESET], FNCT, 
     NULL);

  pm(INIT, PORBIT[GO],
     PUT, PORBIT[GO], porbit_go,
     INIT, PORBIT[RESET],
     PUT, PORBIT[RESET], porbit_reset,
     NULL);

  /* create continuation memory  -- moved to cont/cont_install.c  8/20/97 BAM 
  pm(CREATE_ELEM, "Memory.Continuation", MEMRY, NULL);
  pm(INIT, "Memory.Continuation", CONT_MEMORY, NULL);
   */

}

static void
porbit_reset()
{
  pm(PUT, PORBIT[VARB], 0,
     PUT, PORBIT[PARAM], 0,
     PUT, PORBIT[PERIOD], 1,
     PUT, PORBIT[NUMSTEPS], 0,
     PUT, PORBIT[ALGORITHM], 0,
     PUT, PORBIT[VALUE], 0.0,
     PUT, PORBIT[PSTEPSIZE], 0.01,
     NULL);
  
}
