/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef	NPOLYLISTPDEFS
#define	NPOLYLISTPDEFS
/*
 * Private definitions for PolyList's
 */

#include "bboxP.h"
#include "npolylist.h"

#define NPLMAGIC GeomMagic ('P', 1)

typedef struct NPoly
{
	int	n_vertices;
	int	vi0;		/* Offset of first vertex index in vi[] array */
	ColorA  pcol;		/* polygon color */
}  NPoly;

struct NPolyList
{
	GEOMFIELDS
	int	n_polys;
	int	n_verts;
	int	pdim;		/* Space dimension, *including* homogeneous component */
	NPoly	*p;		/* array of polygon definitions */
	int	*vi;		/* array of vertex indices (all faces) */
	int	nvi;		/* room allocated for vertex indices */
	float	*v;		/* v[n_verts][pdim] */
	ColorA	*vcol;		/* vcol[n_verts] */
	float	*st;		/* st[n_verts][2] texture coords */
	int	flags;
	int	seq;		/* for 4D->3D tforms */
#  define	  PL_HASVCOL	0x4	/* Per-vertex colors (vcol) valid */
#  define	  PL_HASPCOL	0x8	/* Per-polygon colors (pcol) valid */
#  define	  PL_HASST	0x20	/* texture coords */
			/* For 4-D points, see geomflags & VERT_4D */
};


extern NPolyList *NPolyListCreate(NPolyList *exist, GeomClass *Class, va_list a_list);
extern NPolyList *NPolyListCopy( NPolyList *poly );
extern NPolyList *NPolyListDelete( NPolyList *poly );
extern GeomClass *NPolyListMethods();

#endif/*NPOLYLISTPDEFS*/
