/*
   Egon Animator
   Copyright (C) 1997, 1998  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

/*
 * egon.h
 */

#include "../common/fonts.h"
#include "types.h"

typedef struct plugin_t {
        int row, col;                  /* geometry */
        int ph;                         /* handle */
        char *name;                     /* file name */
        int displayed;                  /* started yet? */
} plugin_t;

typedef struct s_buffer {
	char name[1024];	/* identifies the buffer */
	char path[1024];	/* file name */
	ani_object *cast;	/* objects in animation sequence */
	unsigned int now;	/* time in ms */
	unsigned int delta;	/* ms between frames */
	unsigned int duration;	/* of animation */
	unsigned int width, height;
	int state;		/* ANI_STOP et al */
	char *bg;		/* background */
	int change;		/* if there are pending changes */
	plugin_t *plugin;	/* array of plugins */
	int nplugin;		/* number of plugins */
	struct s_buffer *next;	/* next buffer in buffer ring */
} buffer;

typedef struct s_window {
	ani_object *object;	/* selected object */
	ani_script *script;	/* selected tick */
	buffer *buf;		/* buffer */
	struct egon_ui *ui;	/* widgets */
	struct s_window *next;	/* next window in window ring */
} window;

/* from window.c */

extern window *w_list;

extern void activate_window(window *);
extern void llpr(char *);
extern void free_window(window *);
extern window *new_window(buffer *, window *);
extern int remove_window(window *);
extern int split_window(window *);
extern void init_windows(buffer *, int *, char **);
extern void exit_windows(void);
extern void show_cur(window *);
extern void hide_cur(window *);

extern void draw_input(char *);
extern void draw_status(char *);
extern void draw_buffer(window *);

extern void mainloop(void);


/* from matrix.c */
extern void free_matrix(ani_object *);
extern ani_object *last_object(buffer *);
extern ani_script *last_script(ani_object *);
extern int ins_format(buffer *, ani_object *, ani_script *, int);
extern int ret_format(buffer *, ani_object *, ani_script *);
extern char *type2name(int);
extern int name2type(char *);

/* from cmds.c */
extern void init_cmds(void);

/* from buffer.c */
extern buffer *b_list;
extern char *buffer_name(char *);
extern buffer *new_buffer(char *, char *);
extern buffer *free_buffer(buffer *);
extern void plugin_unique_name(char *, char *);
extern char *plugin_basedir(buffer *, char *);
extern buffer *find_buffer_by_name(char *);
extern int buffer_plugin2index(buffer *, int);


extern int ok2print;
extern int siod_interpreter;

/* from print.c */
extern int paper_width;
extern int paper_height;
extern int margin;
extern void preview(void);
extern void printer(void);

/* from railway.c */
extern int errorflag;
extern char *interpreter2name(int);
extern int name2interpreter(char *);
extern int register_interpreter(char *, double (*)(char *), void (*)(char *));
extern int is_constant(char *);
extern double parse_expr(ani_object *, char *, int, int);
extern int calc_matrix(ani_object *);
#define execute(p) exec_expr(siod_interpreter,(p))
extern void exec_expr(int, char *);
extern void va_execute(char *, ...);

/* from fileio.c */
extern char *loader_patterns[];
extern char *saver_patterns[];
extern void register_format(int (*)(char *, buffer *),
			int (*)(char *, buffer *),
			int (*)(char *), char *);
extern void fileio_init(void);
extern int savematrix(char *, buffer *, char *);
extern int loadmatrix(char *, buffer *, char *);
extern char *guess_file_format(char *);

extern int make_backups;

/* from position.c */

extern void init_position(void);

