/*
   Copyright (C) 1998  Ulric Eriksson <ulric@edu.stockholm.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the Licence, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

#ifndef _XawCombo_h
#define _XawCombo_h

#include <X11/Xmu/Converters.h>

/***********************************************************************
 *
 * Combo Widget (subclass of CompositeClass)
 *
 ***********************************************************************/

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 hSpace 	     HSpace		Dimension	4
 height		     Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 orientation	     Orientation	XtOrientation	vertical
 vSpace 	     VSpace		Dimension	4
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0

*/


/* New fields */
#define XtNcomboText "comboText"
#define XtCComboText "ComboText"
#define XtNcomboList "comboList"
#define XtCComboList "ComboList"
#define XtNcomboTop "comboTop"
#define XtCComboTop "ComboTop"
#define XtNcomboData "comboData"
#define XtCComboData "ComboData"
#define XtNcomboNData "comboNData"
#define XtCComboNData "ComboNData"

/* Class record constants */

extern WidgetClass comboWidgetClass;

typedef struct _ComboClassRec *ComboWidgetClass;
typedef struct _ComboRec      *ComboWidget;

extern void combo_text_change(Widget, char *);

#endif /* _XawCombo_h */
