
#ifndef __arrayclass_h__
#define __arrayclass_h__

#include "lisptype.h"
#include "lispobject.h"
#include "genericobject.h"

class ArrayClass : public GenericClass
{
public: //required
    ArrayClass(LispInt aSize,LispObject* aInitialItem);
    virtual ~ArrayClass();
    virtual LispCharPtr Send(LispArgList& aArgList);
    virtual LispCharPtr TypeName();
public: //array-specific
    inline LispInt Size();
    inline LispObject* GetElement(LispInt aItem);
    inline void SetElement(LispInt aItem,LispObject* aObject);

private:
    LispInt iSize;
    LispPtr* iArray;
};

//TODO move these to an inl file
inline LispInt ArrayClass::Size()
{
    return iSize;
}

inline LispObject* ArrayClass::GetElement(LispInt aItem)
{
    LISPASSERT(aItem>0 && aItem<=iSize);
    return iArray[aItem-1].Get();
}

inline void ArrayClass::SetElement(LispInt aItem,LispObject* aObject)
{
    LISPASSERT(aItem>0 && aItem<=iSize);
    iArray[aItem-1].Set(aObject);
}

#endif

