
#ifndef __matrix_h__
#define __matrix_h__

#include "fixed.h"
#include "grower.h"

#define TrigBits 10
#define NrTrigBins (1L<<TrigBits)
#define TrigMask   (NrTrigBins-1)
#define HalfPi     (NrTrigBins>>2)

class CTrig
{
public:
    CTrig();
    Fixed Sin(PlatInt x);
    Fixed Cos(PlatInt x);
private:
    Fixed bin[NrTrigBins];
};


class CMatrix
{
public:
    Fixed xf[4][4];
};

class CVector
{
public:
    CVector()
    {xf[0]=xf[1]=xf[2]=0;xf[3]=FixedOne;};
    CVector(Fixed x, Fixed y, Fixed z);
public:
    Fixed xf[4];
};

class GlobalTransform : public CArrayGrower<CMatrix>
{
public:
    GlobalTransform();
    void PushMatrix();
    void PopMatrix();
    void Apply(CMatrix& aMatrix);
    void Transform(CVector& aTarget, const CVector& aSource);
    void TransformNormal(CVector& aTarget, const CVector& aSource);
    void Transform(PlatInt& x, PlatInt& y, PlatInt& z);
    void Transform(CVector& aTarget, PlatInt x, PlatInt y, PlatInt z);
};
void UnFixVector(PlatInt& x, PlatInt& y, PlatInt& z, CVector& aSource);


void ZeroVector(CVector& aTarget);
void MatrixMul(CMatrix& aTarget, CMatrix& m1, CMatrix& m2);
void MatMulVec(CVector& aTarget, CMatrix& m, const CVector& v);
void IdentityMatrix(CMatrix& aTarget);
void ZeroMatrix(CMatrix& aTarget);
void Translate(CMatrix& aTarget, Fixed x, Fixed y, Fixed z);
void RotateZ(CMatrix& aTarget, CTrig& aTrig, PlatInt aAngle);
void RotateY(CMatrix& aTarget, CTrig& aTrig, PlatInt aAngle);
void RotateX(CMatrix& aTarget, CTrig& aTrig, PlatInt aAngle);
void Scale(CMatrix& aTarget, Fixed aScaleX, Fixed aScaleY, Fixed aScaleZ);





#endif

