#!/bin/bash
# $Id: makedb.sh,v 1.2 1999/11/30 01:42:34 mag Exp $
#set -e
export LIBDIR=/usr/lib/barracuda
export TMPDIR=/var/tmp/barracuda
export PATH=$PATH:/usr/lib/postgresql/bin

mkdir -p $TMPDIR
if psql -ltq |grep '|barracuda$'
then
	echo "Database exists."
else
	echo "Database does not exists, creating it."
	createdb barracuda
	echo "Creating postgres users..."
	userid=`psql -qt -d barracuda -c "
		DELETE FROM pg_shadow where usename ~ '^barracuda_' ;
		DELETE FROM pg_group where groname ~ '^barracuda_';
		create user barracuda_admin with password admin createuser;
		update pg_shadow set usecatupd = 't' where usename='barracuda_admin';
		SELECT usesysid from pg_shadow where usename='barracuda_admin';
	"`
	maxgroup=`psql -qt -d barracuda -c "select max(grosysid) from pg_group;"`
	if [ -z $maxgroup ]
	then
		maxgroup=100
	fi
	echo "Userid is $userid"
	echo "Maxgroup is $maxgroup"
	echo "Creating postgres groups..."
	psql -qt -d barracuda -c "
		INSERT INTO pg_group (groname,grosysid,grolist) values ('barracuda_admin',$maxgroup +1 , '{$userid}');
		INSERT INTO pg_group (groname,grosysid,grolist) values ('barracuda_write',$maxgroup +2 , '{$userid}');
		INSERT INTO pg_group (groname,grosysid,grolist) values ('barracuda_read',$maxgroup +3 , '{$userid}');
	"
	echo "Creating the database..."
	psql -t -d barracuda <$LIBDIR/makedb.sql 2>&1 |tee $TMPDIR/makedb.out | grep ERR
	$LIBDIR/refint.pl barracuda <$LIBDIR/makedb.sql
	echo "Importing mime types..."
	$LIBDIR/gettypes.sh

	if grep -sq ERR $TMPDIR/makedb.out
	then
		echo -n "Do you want to examine the error file ($TMPDIR/makedb.out) (y/N) ? "
		read ANS
		if [ -z "$ANS" -o "$ANS" = "N" -o "$ANS" = "n" ];
		then
			rm -f $TMPDIR/makedb.out
			echo "$TMPDIR/makedb.out has been removed."
		fi
	else 
		rm -f $TMPDIR/makedb.out
	fi
	rmdir $TMPDIR
fi
echo "Done."
echo "Do not forget to check if /etc/postgresql/pg_hba conf contains"
echo "the following line:"
echo "host         all         127.0.0.1     255.255.255.255   crypt"

