#!/usr/bin/perl -w

use strict;

use DBI;

my $database=$ARGV[0];

print "$database\n";

my %referencers;
my %referenceds;
my $name;
sub debug {
	my $debug=11;
	if ($debug <= $_[0]) {
		print $_[1];
	}
}

my $dbh = DBI->connect("dbi:Pg:dbname=$database",'','') or die "cannot connect $database\n";

while (<STDIN>) {
	if (/create table/i) {
		my @line;
		debug 1, $_;
		@line = split;
		$name=$line[2];
		debug 1, "name=$name\n";
	}

	if (/references/i) {
		my @bar;
		debug 1, $_;
#		s/^[ 	]*([^ ]*) .*references ([^\(]*).(.[^\)]*\)).*\$/\\1 \\2 \\3/;
		s/\s*(\S+)\s.*references ([^\(]*)\(([^)]*)\).*/$1 $2 $3/i or die "regexp does not match";
		@bar = split;
		debug 1, "$bar[0];$bar[1];$bar[2]\n";
		debug 1, "insert into cng_foreign_constrainsts (primarytab,primaryfield,refdtab,refdfield) values  ($bar[1], $bar[2], $name, $bar[0]);\n";
		push @{$referencers{"$bar[1]:$bar[2]"}} , "$name:$bar[0]";
		$referenceds{"$name:$bar[0]"} = "$bar[1]:$bar[2]";
	}
}

foreach my $prim (keys %referencers) {
	my $tusql='';
	my $tdsql ='';
	my ($primarytab,$primaryfield)=split(':',$prim);
	my $sumlen = scalar @{$referencers{$prim}};
	debug 2, "$primarytab($primaryfield) is referenced by @{$referencers{$prim}} length \n";
	$tusql .= "CREATE TRIGGER tu_${primarytab}_${primaryfield}_pkey
		AFTER UPDATE ON $primarytab FOR EACH ROW
		EXECUTE PROCEDURE check_foreign_key (
			$sumlen, 'cascade', '$primaryfield'\n";
	$tdsql .= "CREATE TRIGGER td_${primarytab}_${primaryfield}_pkey
		BEFORE DELETE ON $primarytab FOR EACH ROW
		EXECUTE PROCEDURE check_foreign_key (
			$sumlen, 'restrict', '$primaryfield'\n";
	foreach my $refer (@{$referencers{$prim}}) {
		my ($refertab,$referfield)=split(':',$refer);
		debug 2, "$refertab($referfield)\n";
		$tusql .= ",'$refertab','$referfield'\n";
		$tdsql .= ",'$refertab','$referfield'\n";
	}
	$tusql .= ");\n";
	$tdsql .= ");\n";
	my $tusth= $dbh->prepare($tusql);
	my $tdsth= $dbh->prepare($tdsql);
	$tusth->execute or die "executing $tusql";
	$tdsth->execute or die "executing $tdsql";
	$tusth->finish;
	$tdsth->finish;

	debug 10, "$tusql\n";
	debug 10, "$tdsql\n";
}

foreach my $refer (keys %referenceds) {
	my ($refertab,$referfield)=split(':',$refer);
	debug 3, "$refertab($referfield)\n";
	my ($primarytab,$primaryfield)=split(':',$referenceds{$refer});
	my $tiusql = "create trigger tiu_${refertab}_${referfield} 
		BEFORE INSERT OR UPDATE ON $refertab FOR EACH ROW 
		EXECUTE PROCEDURE check_primary_key 
		('$referfield','$primarytab','$primaryfield');";
	my $tiusth= $dbh->prepare($tiusql);
	$tiusth->execute or die "executing $tiusql";
	$tiusth->finish;
	debug 10 ,"$tiusql\n";
}
$dbh->disconnect;


