package diskless;
use strict;
return 1;

sub tftpbootdir
{
	return "/var/lib/diskless";
}

sub mymkdir
{
	my $class = $_[0];
	my $dir=$_[1];
	my $error=$_[2];

	die if (!ref($error) or defined ($$error));

	if ( ! -d $dir )
	{
		if (mkdir($dir,oct('755')))
		{
			return 1;
		}
		else
		{
			$$error="error"->new("error"->general,
				"Cannot mkdir $dir: $!");
			return 0;
		}
	}
	return 1;
}

sub copyfile
{
	my $class = shift;
	my $src_name_full = shift;
	my $dst_name_full = shift;
	my $error = shift;
	my $rc;

	die if (!ref($error) or defined ($$error));

	$rc=open(SRC,"<".$src_name_full);
	if (!$rc)
	{
		$$error = "error"->new("error"->general,
			"Cannot open $src_name_full for reading");
		return 0;
	}
	$rc=open(DST,">".$dst_name_full);
	if (!$rc)
	{
		$$error = "error"->new("error"->general,
			"Cannot open $dst_name_full for writing");
		return 0;
	}

	binmode(SRC);
	binmode(DST);
		
	while(1)
	{
		my $data;
		my $rc = read(SRC,$data,10240);
		if (!defined($rc))
		{
			$$error = "error"->new("error"->general,
				"Cannot read from $src_name_full");
			return 0;
		}
		last if ($rc <= 0);
		print(DST $data) or die "Cannot write to $dst_name_full";
	}

	$rc=close(SRC);
	if (!$rc)
	{
		$$error = "error"->new("error"->general,
			"Cannot close $src_name_full");
		return 0;
	}

	$rc=close(DST);
	if (!$rc)
	{
		$$error = "error"->new("error"->general,
			"Cannot close $dst_name_full");
		return 0;
	}
	return 1;
}

sub input
{
	my($class)=$_[0];
	my($message)=$_[1];
	my($defanswer)=$_[2];
	my($reply);

	printf "%-39s [%-20s]: ",$message,$defanswer; 
	$reply=<STDIN>; chop($reply); if ($reply eq "") { $reply=$defanswer; }
 
	return $reply;
}

sub yninput
{
	my($class)=$_[0];
	my($message)=$_[1];
	my($defanswer)=$_[2];
	my($reply);

	printf "%s? (y/n) [%s]: ",$message,$defanswer; 
	$reply=<STDIN>; chop($reply); if ($reply eq "") { $reply=$defanswer; }
 
	return $reply;
}

sub config
{
my $class = shift;
my $object = shift;
my $options = shift;

my $firstq = 1;

my $n=0;
my $optiondesc;
$optiondesc = $object->getoptiondescn($n);
while (defined($optiondesc))
{
	my $id = $optiondesc->{"id"};
	my $valid = $optiondesc->{"valid"};
	my $value = $object->getoption($id);
	$value = $optiondesc->{"default"} if (!defined($value));
	$value = $options->{$id} if (defined($options->{$id}));
	my $oldvalue = $value;

	my $dontforceask = (defined($options->{"defaults"}) || defined($options->{$id}));
	my $isvalid = 1;
	my $complain = 1;
	$isvalid = ($value =~ /$valid/) if (defined($valid));

	while ( !$dontforceask or !$isvalid)
	{
		$dontforceask=1;

		if ($firstq)
		{
			print "\nEnter ? for help in following questions\n\n";
			$firstq = 0;
		}
		if (!$isvalid and $complain)
		{
			print "\nInvalid value, try again\n";
		}

		$value = "diskless"->input($optiondesc->{"prompt"},$oldvalue);
		if ($value eq "?")
		{
			print $optiondesc->{"help"},"\n";
			$isvalid = 0;
			$complain = 0;
		}
		else
		{
			$isvalid = 1;
			$isvalid = ($value =~ /$valid/) if (defined($valid));
			$complain = 1;
		}
	}

	$object->setoption($id,$value);
#!	print "",$optiondesc->{"id"}," is ",$object->getoptionvalue($id,"\n";

	$n++;
	$optiondesc = $object->getoptiondescn($n);
}
}

my %packages;
sub getpackage
{
	my $package_name=shift;
	my $error = shift;

	die if (!ref($error) or defined ($$error));

	my $rc;

	if (!defined($packages{$package_name}))
	{
		$rc=open(PIPE,"dpkg -L $package_name|");
		if (!$rc)
		{
			$$error="error"->new("error"->general,
				"Unable to execute dpkg");
			return undef;
		}
		while (<PIPE>)
		{
			chomp($_);
			next if (/^[^\/]/);
			$packages{$package_name}->{$_} = 1;
		}
		$rc = close(PIPE);
		if (!$rc)
		{
			$$error="error"->new("error"->general,
				"Unable to close pipe to dpkg");
			return undef;
		}
	}
	return $packages{$package_name};
};
