/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <strings.h>
#include <fnmatch.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <signal.h>
#include <unistd.h>
#include <wait.h>

#include "about.h"
#include "interface.h"
#include "icons.h"
#include "images.h"
#include "selectdir.h"
#include "loadcat.h"
#include "savecat.h"
#include "edit.h"
#include "categories.h"
#include "search.h"
#include "exit.h"
#include "erreur.h"
#include "clean.h"
#include "buttonbar.h"
#include "report.h"
#include "setup.h"
#include "addisk.h"
#include "text.h"
#include "waitbox.h"

GtkWidget *filew;
GtkWidget *hpaned;
GtkWidget *tree_window;
GtkWidget *path_entry;
GtkWidget *status_bar1;
GtkWidget *status_bar2;
GtkWidget *status_bar3;

Folder *selected_tree_folder;
Folder *selected_clist_folder;
gint status_context1, status_context2;
Folder *dumy_fold;


/* affiche dans la fenetre de droite, les repertoires et fichiers avec les icons */
void list_folder(Folder *folder)
{
  gchar *temp[5] = { " ", " " ," ", " "," "};
  int fin = 0;
  int i;
  int j;
  int k;
  unsigned long int total_size = 0;
  gchar info[100];
 
 // temp[4] = (char *)realloc(temp[4],100*sizeof(char)); 

  selected_clist_folder = NULL;
  gtk_clist_freeze ((GtkCList *)clist);
  if ((is_folder(folder) == 1)||(is_disk(folder) == 1))
    {
      gtk_clist_clear((GtkCList *)clist);
      if(is_folder(folder) == 1)
	{
	  gtk_clist_append((GtkCList *)clist, (gchar **) temp);
	  gtk_clist_set_pixtext((GtkCList *)clist,0,0,"..",3,folder_pixmap,folder_mask );  
	  gtk_clist_set_row_data((GtkCList  *)clist,0,folder/*->parent*/);
	  k = 1;
	}
      else k = 0;
      for ( i=k ; i<folder->nb_folders+k ; i++ )
	{
	  
	  temp[1] = g_strdup("0");
	  temp[2] = g_strdup(get_time(folder->folders[i-k].date));
	  temp[3] = g_strdup(categories[folder->folders[i-k].categorie]);
	  temp[4] = g_strdup(descriptions[folder->folders[i-k].description]);
	  
	  gtk_clist_append((GtkCList *)clist, (gchar **) temp);
	  gtk_clist_set_pixtext((GtkCList *)clist,i,0,folder->folders[i-k].name,3,folder_pixmap,folder_mask );     
	  gtk_clist_set_row_data((GtkCList  *)clist,i,&folder->folders[i-k]);
	}
      
      for ( i=(folder->nb_folders +k) ; i<(folder->nb_files+folder->nb_folders +k) ; i++ )
	{
	  temp[1] = g_strdup(get_size(folder->files[i-(folder->nb_folders +k)].taille));
	  temp[2] = g_strdup(get_time(folder->files[i-(folder->nb_folders +k)].date));
	  temp[3] = g_strdup(categories[folder->files[i-(folder->nb_folders +k)].categorie]);
	  if((folder->files[i-(folder->nb_folders +k)].description == 0)&&(folder->files[i-(folder->nb_folders +k)].information != NULL))
	    {
	      strncpy(info,folder->files[i-(folder->nb_folders +k)].information,90);
	      info[89] = '\0';
	      temp[4] = info;
	    }
	  else temp[4] = g_strdup(descriptions[folder->files[i-(folder->nb_folders +k)].description]);
	  gtk_clist_append((GtkCList *)clist, (gchar **) temp);
	  j = 0;
	  fin = 0;
	  while ((fin == 0)&&(j <nb_extensions))
	    {
	      if (fnmatch(ext_list[j].name,folder->files[i-(folder->nb_folders +k)].name, (1 << 4)) == 0)
		{
		  gtk_clist_set_pixtext((GtkCList  *)clist,i,0,folder->files[i-(folder->nb_folders +k)].name,3,pixmap_list[ext_list[j].pos],mask_list[ext_list[j].pos] );
		  fin = 1;
		}
	      j++;
	    }
	  if (fin == 0) gtk_clist_set_pixtext((GtkCList  *)clist,i,0,folder->files[i-(folder->nb_folders +k)].name,3,file_pixmap,file_mask ); 
	  gtk_clist_set_row_data((GtkCList  *)clist,i,&folder->files[i-(folder->nb_folders +k)]);
	  total_size = total_size + (folder->files[i-(folder->nb_folders +k)].taille & size_mask);
	}            
    }
  gtk_clist_thaw   ((GtkCList *)clist);
  total_size = total_size / 1024;
  sprintf(info,"%d folders  %d files  total size %lu ko",folder->nb_folders,folder->nb_files,total_size);
  
  gtk_statusbar_pop((GtkStatusbar *)status_bar2,status_context2);
  gtk_statusbar_push((GtkStatusbar *)status_bar2,status_context2,info);
}





/*affiche la liste des fichiers quand un repertoire est selectionn */
static void cb_itemsignal(GtkWidget *widget,GtkCTreeNode *node,gint z)
{
  DirNode *dirnode;
  char *tmp;

  dirnode=gtk_ctree_node_get_row_data(GTK_CTREE(widget),node);

  selected_tree_folder = dirnode->folder;
  selected_clist_folder = NULL;
  tmp = g_strdup(dirnode->path);
  tmp[strlen(tmp)/*-strlen(dirnode->folder->name)*/ -1] = '\0';
  gtk_entry_set_text (GTK_ENTRY (path_entry), tmp);
  gtk_entry_append_text (GTK_ENTRY (path_entry), "/");
  if (is_link(selected_tree_folder) == 1)
    {
      char link_path[1024];
      char path[1024];
      char *rep;

      rep =  gtk_entry_get_text(GTK_ENTRY (path_entry));
      strcpy(path,rep);
      path[strlen(path) -strlen(dirnode->folder->name) -1] = '\0';
      if (selected_tree_folder->folders[0].name[0] == '/') 
	{
	  erreur_dialog(window, "Invalid link", "The target is out of the disk", "ERROR !");
	  return;
	}
      strcpy(link_path,selected_tree_folder->folders[0].name);
      resolve_link(selected_tree_folder->parent,link_path,path,0);
      
    }
  else
    {
      list_folder(dirnode->folder);
    }
}

/* quand un repertoire est deselectionne dans l'arbre */
static void cb_itemsignal2(GtkWidget *widget,GtkCTreeNode *node,gint i)
{
  selected_folder = NULL;
  selected_tree_folder = NULL;
}


static void destroy_cb(gpointer data)
{
	DirNode *node=data;
	g_free(node->path);
	g_free(node);
}

static void expand_cb(GtkWidget *widget,GtkCTreeNode *parent_node)
{
  gchar *text,*dummy="dummy";
  GtkCTreeNode *node,*sub_node;
  DirNode *parent_dirnode,*dirnode;
  gboolean has_subdir=FALSE;
  gchar *path;

  int i;
  
  parent_dirnode=gtk_ctree_node_get_row_data(GTK_CTREE(widget),parent_node);
  if(!parent_dirnode->scanned)
    {
      gtk_clist_freeze(GTK_CLIST(widget));
      node=gtk_ctree_find_by_row_data(GTK_CTREE(widget),parent_node,NULL);
      gtk_ctree_remove_node(GTK_CTREE(widget),node);
     
      for(i=0;i<parent_dirnode->folder->nb_folders;i++)
	{
	  
	  {
	    dirnode=g_malloc0(sizeof(DirNode));
	    dirnode->folder = &parent_dirnode->folder->folders[i];
	    path=g_strconcat(parent_dirnode->path,dirnode->folder->name,NULL);
	    dirnode->path=g_strconcat(path,"/",NULL);
	    text = dirnode->folder->name;
	    if(dirnode->folder->nb_folders > 0)
	      has_subdir=TRUE;
	    else
	      has_subdir=FALSE;
	    node=gtk_ctree_insert_node(GTK_CTREE(widget),parent_node,NULL,&text,4,folder_pixmap,folder_mask,ofolder_pixmap,ofolder_mask,!has_subdir,FALSE); 
	    gtk_ctree_node_set_row_data_full(GTK_CTREE(widget),node,dirnode,destroy_cb);
	    if(has_subdir)
	      sub_node=gtk_ctree_insert_node(GTK_CTREE(widget),node,NULL,&dummy,4,NULL,NULL,NULL,NULL,FALSE,FALSE);
	  }
	  g_free(path);
	}
      gtk_ctree_sort_node(GTK_CTREE(widget),parent_node);
      gtk_clist_thaw(GTK_CLIST(widget));	
      parent_dirnode->scanned=TRUE;
    }
}


////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////

void quit_prog(GtkWidget *w, gpointer data) 
{
  char *tmp;
  if(is_modified == 1)
    {
      have_to_clear = 0;
      have_to_quit = 1;
      exit_dialog(w,data);
    }
  else 
    {
     
      if ((tmp = getenv("HOME")) == NULL)
	{
	  return;
	}
      if (tmp[strlen(tmp) - 1] != '/') tmp = g_strconcat(tmp,"/",NULL);
      tmp = g_strconcat(tmp,".gtktalog/temp/",NULL);
      

      switch (fork())
	{
	case 0: /* child */
	  seteuid(getuid()); /* reduce likelyhood of security holes when running setuid */
	  execlp("rm", "rm","-rf", tmp, NULL);
	  exit(1);
	  break;
	case -1:
	  fprintf(stderr, "unable to fork: \n");
	  fflush(stdout);
	  break;
	default: /* parent */
	  wait(NULL);
	}

      gtk_main_quit();
    }
}




void new_file(GtkWidget *w, gpointer data)
{
  have_to_quit = 0;  
  have_to_clear = 0;
  if (is_modified == 1)
    {
      have_to_clear = 1;
      exit_dialog(w,data);
      return;
    }
  if (have_to_clear == 0)
    {
      if (racine.folders != NULL) free(racine.folders);
      if (racine.files != NULL) free(racine.files);
      racine.nb_folders = 0;
      racine.nb_files = 0;
      nb_categories = 1;
      nb_descriptions = 1;
    }
  curent_filename=g_strdup("");
  clear_all(w,data);
  gtk_statusbar_pop((GtkStatusbar *)status_bar1,status_context1);
  gtk_statusbar_push((GtkStatusbar *)status_bar1,status_context1,"");

 if (have_to_load == 1)
    {
      have_to_load = 0;
      if (load_cat_from_file(load_filename) == -1)
	{
	  erreur_dialog(w, "C'ant open file", "or this is not a GTKtalog file.", "ERROR !");
	  return;
	}
      curent_filename = g_strdup(load_filename);
     // if (filew != NULL) gtk_widget_destroy(filew);
      affichage_tree();
      is_modified = 0;
 
      gtk_window_set_title(GTK_WINDOW(window),curent_filename);
      gtk_statusbar_pop((GtkStatusbar *)status_bar1,status_context1);
      gtk_statusbar_push((GtkStatusbar *)status_bar1,status_context1,curent_filename);
      
    }
}

void affichage_tree()
{
  gchar *node_text="";
  GtkCTreeNode *root_node,*node;
  DirNode *dirnode; 
  int i;

  for(i=0;i<racine.nb_folders;i++)
    {
      root_node=gtk_ctree_insert_node(GTK_CTREE(tree),NULL,NULL,&racine.folders[i].name,4,diskopen_pixmap,diskopen_mask,diskclose_pixmap,diskclose_mask,FALSE,FALSE);
      dirnode=g_malloc0(sizeof(DirNode));
      dirnode->folder = &racine.folders[i];
      dirnode->path=g_strdup("[");
      dirnode->path=g_strconcat(dirnode->path,racine.folders[i].name,NULL);
      dirnode->path=g_strconcat(dirnode->path,"]-> /",NULL);
      gtk_ctree_node_set_row_data_full(GTK_CTREE(tree),root_node,dirnode,destroy_cb);
      node=gtk_ctree_insert_node(GTK_CTREE(tree),root_node,NULL,&node_text,4,NULL,NULL,NULL,NULL,TRUE,TRUE);
    } 
}



void update_tree()
{
 gtk_widget_destroy(tree_window);
 tree_window = create_tree ();
 gtk_paned_add1 (GTK_PANED(hpaned), tree_window);
 gtk_widget_show (tree_window);
 affichage_tree();
}


void clear_all(GtkWidget *w, gpointer data) 
{
  gtk_widget_destroy(tree_window);
  tree_window = create_tree ();
  gtk_paned_add1 (GTK_PANED(hpaned), tree_window);
  gtk_widget_show (tree_window);
  gtk_clist_clear((GtkCList *)clist);
  gtk_entry_set_text (GTK_ENTRY (path_entry), "");
}



/* ouverture d'un catalogue */
void open_cat_ok_sel (GtkWidget *w, GtkFileSelection *fs)
{

  load_filename=g_strdup(gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
  if (is_modified == 1)
    {
      have_to_load = 1;
      new_file(w,fs);
    }
  else
    {
      new_file(w,fs);
      if (load_cat_from_file(gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs))) == -1)
	{
	  erreur_dialog(w, "C'ant open file", "or this is not a GTKtalog file.", "ERROR !");
	  return;
	}
      curent_filename = g_strdup(gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
      if(filew != NULL) gtk_widget_destroy(filew);
      affichage_tree();
      is_modified = 0;
   
      gtk_window_set_title(GTK_WINDOW(window),curent_filename);
      gtk_statusbar_pop((GtkStatusbar *)status_bar1,status_context1);
      gtk_statusbar_push((GtkStatusbar *)status_bar1,status_context1,curent_filename);
    }
}



void open_cat(GtkWidget *w, gpointer data) 
{
  filew = gtk_file_selection_new ("File selection");
   gtk_signal_connect (GTK_OBJECT (filew), "destroy",
		      (GtkSignalFunc) gtk_widget_destroy, &filew);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
		      "clicked", (GtkSignalFunc) open_cat_ok_sel, filew );
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (filew));  
  gtk_widget_show(filew); 
}

/* permet d'enregistrer le catalogue courant dans un fichier*/
void save_cat_ok_sel (GtkWidget *w, GtkFileSelection *fs)
{
  
  if (save_cat_to_file(gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs))) == 0)
    {
      curent_filename=g_strdup(gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
      if (have_to_quit == 1) gtk_main_quit();
      if (have_to_clear == 1)
	{
	  is_modified = 0;
	  new_file(w, NULL);
	  have_to_clear = 0;
	}
      gtk_window_set_title(GTK_WINDOW(window),curent_filename);
      gtk_statusbar_pop((GtkStatusbar *)status_bar1,status_context1);
      gtk_statusbar_push((GtkStatusbar *)status_bar1,status_context1,curent_filename);
    }
 gtk_widget_destroy(filew);
}




void save_cat(GtkWidget *w, gpointer data) 
{
  filew = gtk_file_selection_new ("Save catalog to file");
  gtk_signal_connect (GTK_OBJECT (filew), "destroy",
		      (GtkSignalFunc) gtk_widget_destroy, &filew);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
		      "clicked", (GtkSignalFunc) save_cat_ok_sel, filew );
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (filew));  
  gtk_widget_show(filew);
}


void fast_save(GtkWidget *w, gpointer data)
{
  if (strlen(curent_filename) == 0)
    {
      save_cat(w, data);
      // printf(curent_filename);
    }
  else
    {
      if (save_cat_to_file(curent_filename) == -1)
	{
	  canceled = 1;
	  erreur_dialog(w, "Can't write to file:", curent_filename, "ERROR !");
	}  
      else
	{
	  if (have_to_quit == 1) gtk_main_quit();
	  if (have_to_clear == 1)
	    {
	      is_modified = 0;
	      new_file(w, NULL);
	      have_to_clear = 0;
	    }
	  else is_modified = 0;
	}
     }
}



static GtkItemFactoryEntry menu_items[] = {
  {"/_File",         NULL,         NULL, 0, "<Branch>"},
  {"/File/_New",     "<control>N", new_file, 0, NULL},
  {"/File/_Open",    "<control>O", open_cat, 0, NULL},
  {"/File/_Save",  "<control>S", fast_save, 0, NULL},
  {"/File/Sa_ve As", "<control>V",save_cat , 0, NULL},
  {"/File/sep1",     NULL,         NULL, 0, "<Separator>"},
  {"/File/Quit",     "<control>Q", quit_prog, 0, NULL},
  {"/Edit",      NULL,         NULL, 0, "<Branch>"},
  {"/Edit/_Find file",  "<control>F",         open_search_dialog, 0, NULL},
  {"/Edit/_Add disk",     "<control>A",show_select_dir_win , 0, NULL},
  {"/Edit/Create _Report",     "<control>R",open_report_dialog , 0, NULL},
  {"/Edit/sep1",     NULL,         NULL, 0, "<Separator>"}, 
  {"/Edit/_Edit categories", NULL, edit_categories, 0, NULL},
  {"/Edit/Clean descriptions", NULL, clean_description, 0, NULL},
  //under construction
  {"/Edit/Setup ...",     NULL,run_setup , 0, NULL},
  {"/_Find file",      NULL, open_search_dialog, 0, NULL},
  {"/_Fast add",      NULL, fast_add_disk, 0, NULL},
  {"/_Help",         NULL,         NULL, 0, "<LastBranch>"},
  {"/_Help/About",    "<control>H", get_about_dialog , 0, NULL},
};

void get_main_menu(GtkWidget *window, GtkWidget ** menubar)
{
  int nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);
  GtkItemFactory *item_factory;
  GtkAccelGroup *accel_group;
  
  accel_group = gtk_accel_group_new();
  item_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", 
				      accel_group);
  gtk_item_factory_create_items(item_factory, nmenu_items, menu_items, NULL);
  gtk_accel_group_attach (accel_group, GTK_OBJECT (window));
  if (menubar)
    *menubar = gtk_item_factory_get_widget(item_factory, "<main>");
}


void change_fold(Folder *folder)
{
  dumy_fold = folder;
}


void resolve_link(Folder *folder,char *link_path, char *cur_path, int i) //donne la position actuelle sur link_path
{
  char tmp[200];
  char path[200];
  int j;
  int fin;


  j = 0;
  fin = 0;
  while((i < strlen(link_path))&&(fin == 0))
    {
      tmp[j] = link_path[i];
      if (tmp[j] == '/') fin = 1;
      i++;
      j++;
    }
  tmp[j] = '\0';
  if (strlen(tmp) > 1)
    {
      /* on remonte dans le rep pre */
      if ((strcmp(tmp,"../") == 0)||(strcmp(tmp,"..") == 0))
	{
	  if (is_disk(folder) == 1)
	    {
	      erreur_dialog(window, "Invalid link", "The target is out of the disk", "ERROR !");
	      return;
	    }
	  cur_path[strlen(cur_path)-(strlen(folder->name)+1)]='\0';
	  resolve_link(folder->parent,link_path,cur_path,i);
	}
      /* sinon, on  va dans le rep fils si . ou ./ on fait rien */
      else if ((strcmp(tmp,"./") != 0)||(strcmp(tmp,".")) != 0)
	{
	  j = 0;
	  fin = 0;
	  if (tmp[strlen(tmp) -1] == '/') tmp[strlen(tmp) -1] = '\0';
	  while ((fin == 0)&&(j < folder->nb_folders))
	    {
	      if (strcmp(tmp,folder->folders[j].name) == 0) fin = 1;
	      else j++;
	    }
	  if (fin == 0)
	    {
	      erreur_dialog(window, "Invalid link", "Can't find target", "ERROR !");
	      return;
	    }
	  else 
	    {
	     // if (is_disk(folder) == 1) cur_path = strcat(cur_path,"/"); 
	      strcpy(path,folder->folders[j].name);
	      path[strlen(path)]='/';
	      path[strlen(folder->folders[j].name)+1]='\0';
	      cur_path = strcat(cur_path,path);
	      resolve_link(&folder->folders[j],link_path,cur_path,i);
	    }
	}
    }
  else
    {
      list_folder(folder);
      gtk_entry_set_text(GTK_ENTRY (path_entry),cur_path );
    }
}

void fin_fils()
{
  wait(NULL);
  signal(SIGCHLD,SIG_DFL);
  signal(SIGCHLD,fin_fils);
}

void selection_made( GtkWidget *clist, gint row, gint column, GdkEventButton *event)
{
  Folder *folder;  
  gchar *rep;
  char path[1024]; 
  gchar *name;
  gint8 pouet;
  GdkPixmap *da_pix;
  GdkBitmap *da_mask ;
 
  gtk_widget_grab_focus(GTK_WIDGET(clist));

  
  if(event != NULL && event->button == 1 && event->type == GDK_2BUTTON_PRESS)
    {
      gtk_clist_get_pixtext((GtkCList *)clist,row,0,&name,&pouet,&da_pix,&da_mask);
      folder = gtk_clist_get_row_data((GtkCList *)clist, row ); 

/* rentre dans le lien symbolique. Le repertoire cible est recherch, et si il existe, on se deplace dedans*/
/* NB: l'adresse de la barre d'adresse (entry_path) est mise a l'adresse reelle du repertoire cible */
/* un double click sur .. ne fera donc pas revenir a repertoire precedent, mais a repertoire pre */
      if (is_link(folder) == 1)
	{
	  char link_path[1024];


	  rep =  gtk_entry_get_text(GTK_ENTRY (path_entry));
	  strcpy(path,rep);
	  if (folder->folders[0].name[0] == '/') 
	    {
	      erreur_dialog(window, "Invalid link", "The target is out of the disk", "ERROR !");
	      return;
	    }
	  strcpy(link_path,folder->folders[0].name);
	  resolve_link(folder->parent,link_path,path,0);
	
	}
      else if (is_file(folder) == 0)
	{
	  if ((row > 0)||(strcmp(name,"..") != 0))
	    {
	      strcpy(path,folder->name);
	      path[strlen(path)]='/';
	      path[strlen(folder->name)+1]='\0';	
	      gtk_entry_append_text(GTK_ENTRY (path_entry),path);
	      list_folder(folder);
	    }
	  else 
	    {	      
	      rep = gtk_entry_get_text(GTK_ENTRY (path_entry));
	      rep[strlen(rep)-(strlen(folder->name)+1)]='\0';
	      gtk_entry_set_text(GTK_ENTRY (path_entry),rep );
	      list_folder(folder->parent); 
	    }
	}
      else  
	{
	  int fin = -2;
	  int i = 0;
	  //on recherche si le fichier doit etre affich avec un soft special
	  if(nbIncludeData > 0)
	    {
	      while(fin == -2)
		{
		  if(i == nbIncludeData) fin = -1; 
		  else if (fnmatch(IncludeData[i].type,folder->name,(1<<4)) == 0) fin = i;
		  i++;
		}
	    }
	  else fin = -1;
	  if((fin == -1)||(strlen(IncludeData[fin].viewer) == 0))
	    {
	      if(text_box_is_open == 0)display_file(folder);
	      else 
		{
		  gtk_text_backward_delete(GTK_TEXT (read_text),gtk_text_get_length(GTK_TEXT (read_text)));
		  if(folder->information != NULL) gtk_text_insert (GTK_TEXT (read_text), fixed_font, NULL, NULL, folder->information, strlen(folder->information));
		  else gtk_text_insert (GTK_TEXT (read_text), fixed_font, NULL, NULL,"", 0);
		}
	    }
	  else
	    {
	      switch(fork()) 
		{
		case 0: 
		  {
		    FILE *file;
		    char *tmpfile;
		    if ((tmpfile = getenv("HOME")) == NULL)
		      {
			return;
		      }
		    //conf_dir = g_strdup( home);
		    if (tmpfile[strlen(tmpfile) - 1] != '/') tmpfile = g_strconcat(tmpfile,"/",NULL);
		    tmpfile = g_strconcat(tmpfile,".gtktalog/temp/",NULL);
		    tmpfile = g_strconcat(tmpfile,folder->name,NULL);
		    file = fopen(tmpfile,"w");
		    fprintf(file,"%s",folder->information);
		    fclose(file);
		    if(strlen(IncludeData[fin].viewerarg) == 0) execlp(IncludeData[fin].viewer,IncludeData[fin].viewer, tmpfile, NULL);
		    else execlp(IncludeData[fin].viewer,IncludeData[fin].viewer, IncludeData[fin].viewerarg, tmpfile, NULL);
		    printf("unable to exec %s\n",IncludeData[fin].viewer);
		    fflush(stdout);
		    exit(1);
		    break;  
		  } 
		default:signal(SIGCHLD,fin_fils);
		}
	    }
	}
    }
  else
    { 
      folder = gtk_clist_get_row_data((GtkCList *)clist, row ); 
      selected_clist_folder = folder;
    }
}


void unselection_made( GtkWidget *clist, gint row, gint column, GdkEventButton *event)
{
  selected_clist_folder = NULL;  
}



void clist_pressed(GtkWidget *wid, GdkEventButton *event, gpointer data)
{
  GtkWidget *list_menu_items;
  GtkWidget *list_menu;
  char buf[128];
 
  if((event->button == 2)&&(selected_clist_folder != NULL))
    {
      selected_folder = selected_clist_folder ;
      edit_folder(wid);
    }
  else if(event->button == 3)
    {
      
      GdkEventButton *bevent = (GdkEventButton *) event; 
      list_menu = gtk_menu_new();
      
      if (selected_clist_folder != NULL)
	{
	  selected_folder = selected_clist_folder ;
	  if(is_folder(selected_clist_folder) == 1 )
	    {
	      list_menu_items = gtk_menu_item_new_with_label("Edit folder");
	      gtk_menu_append(GTK_MENU (list_menu), list_menu_items);
	      gtk_signal_connect_object(GTK_OBJECT(list_menu_items), "activate",
					GTK_SIGNAL_FUNC(edit_folder), (gpointer) g_strdup(buf));
	      gtk_widget_show(list_menu_items);
	    }
	  else if (is_link(selected_clist_folder) == 1 )
	    {
	      list_menu_items = gtk_menu_item_new_with_label("Edit link");
	      gtk_menu_append(GTK_MENU (list_menu), list_menu_items);
	      gtk_signal_connect_object(GTK_OBJECT(list_menu_items), "activate",
					GTK_SIGNAL_FUNC(edit_folder), (gpointer) g_strdup(buf));
	      gtk_widget_show(list_menu_items);
	    }
	  else
	    {
	      list_menu_items = gtk_menu_item_new_with_label("Edit file"); 
	      gtk_menu_append(GTK_MENU (list_menu), list_menu_items);
	      gtk_signal_connect_object(GTK_OBJECT(list_menu_items), "activate",
					GTK_SIGNAL_FUNC(edit_folder), (gpointer) g_strdup(buf));
	      gtk_widget_show(list_menu_items);
	      list_menu_items = gtk_menu_item_new_with_label("Edit Informations"); 
	      gtk_menu_append(GTK_MENU (list_menu), list_menu_items);
	      gtk_signal_connect_object(GTK_OBJECT(list_menu_items), "activate",
					GTK_SIGNAL_FUNC(edit_file_informations),(gpointer) g_strdup(buf));
	      gtk_widget_show(list_menu_items);
	    }
	}
      gtk_menu_popup (GTK_MENU(list_menu), NULL, NULL, NULL, NULL,
		      bevent->button, bevent->time);
    }
}





GtkWidget *create_list (void)
{
  
  GtkWidget *scrolled_window;
  gchar *titles[5] = { "Filename", "Size" , "Date","Category", "Description"};
  
  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, 
				  GTK_POLICY_AUTOMATIC);
  
  
  clist = gtk_clist_new_with_titles( 5, titles);  
  gtk_signal_connect(GTK_OBJECT(clist), "select_row",
		     GTK_SIGNAL_FUNC(selection_made),NULL);
  gtk_signal_connect(GTK_OBJECT(clist), "unselect_row",
		     GTK_SIGNAL_FUNC(unselection_made),NULL);
  
  gtk_clist_set_shadow_type (GTK_CLIST(clist), GTK_SHADOW_OUT);
  gtk_clist_set_column_width (GTK_CLIST(clist), 0, 135);
  gtk_clist_set_column_width (GTK_CLIST(clist), 1, 60);
  gtk_clist_set_column_width (GTK_CLIST(clist), 2, 60);
  gtk_clist_set_column_width (GTK_CLIST(clist), 3, 60);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_window), clist);
  gtk_signal_connect(GTK_OBJECT(clist), "button_press_event", GTK_SIGNAL_FUNC(clist_pressed), NULL);
  gtk_widget_show (clist);
  
  return scrolled_window;
}




void tree_pressed(GtkWidget *wid, GdkEventButton *event, gpointer data)
{
  GtkWidget *list_menu_items;
  GtkWidget *list_menu;
  char buf[128];

  if((event->button == 2)&& (selected_tree_folder != NULL))
    {
      selected_folder = selected_tree_folder ;
      edit_folder(wid);
    }
  else if(event->button == 3)
    {
      GdkEventButton *bevent = (GdkEventButton *) event; 
      list_menu = gtk_menu_new();

      if (selected_tree_folder != NULL)
	{
	  selected_folder = selected_tree_folder ;
	  if (is_folder(selected_tree_folder) == 1 )
	     {
	       list_menu_items = gtk_menu_item_new_with_label("Edit folder");
	       gtk_menu_append(GTK_MENU (list_menu), list_menu_items);
	       gtk_signal_connect_object(GTK_OBJECT(list_menu_items), "activate",
					 GTK_SIGNAL_FUNC(edit_folder), (gpointer) g_strdup(buf));
	       gtk_widget_show(list_menu_items);
	     }
	  else if (is_link(selected_tree_folder) == 1 )
	    {
	      list_menu_items = gtk_menu_item_new_with_label("Edit link");
	      gtk_menu_append(GTK_MENU (list_menu), list_menu_items);
	      gtk_signal_connect_object(GTK_OBJECT(list_menu_items), "activate",
					GTK_SIGNAL_FUNC(edit_folder), (gpointer) g_strdup(buf));
	      gtk_widget_show(list_menu_items);
	    }
	  else
	    {
	      list_menu_items = gtk_menu_item_new_with_label("Edit disk"); 
	      gtk_menu_append(GTK_MENU (list_menu), list_menu_items);
	      gtk_signal_connect_object(GTK_OBJECT(list_menu_items), "activate",
					GTK_SIGNAL_FUNC(edit_folder), (gpointer) g_strdup(buf));
	      gtk_widget_show(list_menu_items);
	       list_menu_items = gtk_menu_item_new_with_label("Delete disk"); 
	       gtk_menu_append(GTK_MENU (list_menu), list_menu_items);
	      gtk_signal_connect_object(GTK_OBJECT(list_menu_items), "activate",
		GTK_SIGNAL_FUNC(delete_folder), (gpointer) g_strdup(buf));
	       gtk_widget_show(list_menu_items);
	    }
        }
      list_menu_items = gtk_menu_item_new_with_label("Add disk"); 
      gtk_menu_append(GTK_MENU (list_menu), list_menu_items);
      gtk_signal_connect_object(GTK_OBJECT(list_menu_items), "activate",
				GTK_SIGNAL_FUNC(show_select_dir_win), (gpointer) g_strdup(buf));

      gtk_widget_show(list_menu_items);
      gtk_menu_popup (GTK_MENU(list_menu), NULL, NULL, NULL, NULL,
		      bevent->button, bevent->time);
    }

}



/* Create the folder tree */
GtkWidget *create_tree (void)
{
  GtkWidget *scroll_win;
  
  void (*handler)(gchar *);
  
  scroll_win=gtk_scrolled_window_new(NULL,NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll_win),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize(scroll_win,150,150);
  gtk_widget_show(scroll_win);
  
  if(!folder_pixmap)
    {
      folder_pixmap=gdk_pixmap_create_from_xpm_d((GdkWindow*) window->window,&folder_mask,NULL,folder_xpm);
      ofolder_pixmap=gdk_pixmap_create_from_xpm_d(window->window,&ofolder_mask,NULL,ofolder_xpm);
      diskopen_pixmap=gdk_pixmap_create_from_xpm_d(window->window,&diskopen_mask,NULL,diskopen_xpm);
      diskclose_pixmap=gdk_pixmap_create_from_xpm_d(window->window,&diskclose_mask,NULL,diskclose_xpm);
      file_pixmap=gdk_pixmap_create_from_xpm_d(window->window,&file_mask,NULL,file_xpm);
    }
  
  tree=gtk_ctree_new(1,0);
  gtk_clist_set_column_auto_resize(GTK_CLIST(tree),0,TRUE);
  gtk_clist_set_selection_mode(GTK_CLIST(tree),GTK_SELECTION_SINGLE);
  gtk_ctree_set_line_style(GTK_CTREE(tree),GTK_CTREE_LINES_DOTTED);
  gtk_signal_connect(GTK_OBJECT(tree),"tree_expand",GTK_SIGNAL_FUNC(expand_cb),NULL);
  gtk_signal_connect (GTK_OBJECT(tree), "tree_select_row",GTK_SIGNAL_FUNC(cb_itemsignal), NULL);
  gtk_signal_connect (GTK_OBJECT(tree), "tree_unselect_row",GTK_SIGNAL_FUNC(cb_itemsignal2), NULL);

   gtk_signal_connect(GTK_OBJECT(tree), "button_press_event", GTK_SIGNAL_FUNC(tree_pressed), NULL);

  gtk_container_add(GTK_CONTAINER(scroll_win),tree);
  gtk_object_set_user_data(GTK_OBJECT(tree),(gpointer)handler);
  gtk_widget_show(tree);
  
  return scroll_win;
}



int main(int argc, char *argv[]) 
{
  GtkWidget *main_vbox;
  GtkWidget *menubar;
  GtkWidget *list_window;
  GtkWidget *hbox;
  
  gtk_init(&argc, &argv);

  selected_tree_folder = NULL;
  selected_clist_folder = NULL;

  /*initialisation des differentes variables*/
  size_mask =  1073741823;
  is_a_disk =  1073741824;
  is_a_folder = 2147483648;
  is_a_file = 3221225472;
  
  is_modified = 0;
  have_to_quit = 0;
  have_to_clear = 0;
  canceled = 0;

  disk_path = g_strdup("/");


  categories = (char **)malloc(sizeof(char *));
  categories[0] = (char *)malloc(2*sizeof(char));
  strcpy(categories[0],"");
  descriptions = (char **)malloc(sizeof(char *));
  descriptions[0] = (char *)malloc(2*sizeof(char));
  strcpy(descriptions[0],"");
  nb_categories = 1;
  nb_descriptions = 1;
 
  curent_filename=g_strdup("");
  is_modified = 0;
//  search_is_open = 0;

  racine.nb_folders = 0;
  racine.nb_files = 0;

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  gtk_signal_connect(GTK_OBJECT(window), "delete_event", 
		     quit_prog, 
		     window);
  gtk_window_set_title(GTK_WINDOW(window), "GTKtalog v0.09");
  gtk_widget_set_usize(GTK_WIDGET(window),600 , 350);
  
  
  gtk_widget_realize(window);

  main_vbox = gtk_vbox_new(FALSE, 1);
  gtk_container_border_width(GTK_CONTAINER(main_vbox), 1);
  gtk_container_add(GTK_CONTAINER(window), main_vbox);
  gtk_widget_show(main_vbox);
  

  get_main_menu(window, &menubar);
  gtk_box_pack_start(GTK_BOX(main_vbox), menubar, FALSE, TRUE, 0);
  gtk_widget_show(menubar);
  
  enable_button_bar(window, main_vbox);

   path_entry = gtk_entry_new_with_max_length (300);
   gtk_entry_set_editable(GTK_ENTRY(path_entry),FALSE);
   gtk_entry_set_text (GTK_ENTRY (path_entry), "");
   gtk_entry_append_text (GTK_ENTRY (path_entry), "");
   gtk_entry_select_region (GTK_ENTRY (path_entry),
			     0, GTK_ENTRY(path_entry)->text_length);
   gtk_box_pack_start (GTK_BOX (main_vbox), path_entry, FALSE, TRUE, 0);
   gtk_widget_show (path_entry);

   //test****************
   load_icons(window);
  

  hpaned = gtk_hpaned_new ();
  gtk_container_add (GTK_CONTAINER(main_vbox), hpaned);
  gtk_paned_set_handle_size (GTK_PANED(hpaned), 10);
  gtk_paned_set_gutter_size (GTK_PANED(hpaned), 10);                       
  gtk_widget_show (hpaned);
  

  list_window = create_list ();
  gtk_paned_add2 (GTK_PANED(hpaned), list_window);
  gtk_widget_show (list_window);
  
  tree_window = create_tree ();
  gtk_paned_add1 (GTK_PANED(hpaned), tree_window);
  gtk_widget_show (tree_window);
  

  hbox = gtk_hbox_new(FALSE, 1);
  gtk_container_border_width(GTK_CONTAINER(hbox), 1);
 // gtk_container_add(GTK_CONTAINER(main_vbox), hbox);
  gtk_box_pack_start(GTK_BOX(main_vbox),hbox,FALSE, FALSE, 0 );
  gtk_widget_show(hbox);


  status_bar1 = gtk_statusbar_new();      
  gtk_box_pack_start (GTK_BOX (hbox), status_bar1, TRUE, TRUE, 0);
  gtk_widget_show (status_bar1);
  status_context1 = gtk_statusbar_get_context_id( GTK_STATUSBAR(status_bar1), "GTKtalog1");

  status_bar2 = gtk_statusbar_new();      
  gtk_box_pack_start (GTK_BOX (hbox), status_bar2,TRUE, TRUE, 0);
  gtk_widget_show (status_bar2);
  status_context2 = gtk_statusbar_get_context_id( GTK_STATUSBAR(status_bar2), "GTKtalog2");

  gtk_widget_show(window);


  if(argc>1)
    {
      if (load_cat_from_file(argv[1]) == -1)
	{
	  erreur_dialog(window, "C'ant open file", "or this is not a GTKtalog file.", "ERROR !");
	}
      else
	{
	  curent_filename=g_strdup(argv[1]);
	  affichage_tree();
	  is_modified = 0;
	  gtk_window_set_title(GTK_WINDOW(window),curent_filename);
	  gtk_statusbar_pop((GtkStatusbar *)status_bar1,status_context1);
	  gtk_statusbar_push((GtkStatusbar *)status_bar1,status_context1,curent_filename);
	}
    }
  
  //under construction
   load_setup();
   text_box_is_open = 0;
//  selected_file = -1;
   current_pid = getpid();
   waitbox_is_open = 0;
   gtk_main();
  
  return(0);
}
/* example-end */
