/*
 setup.c : GMasqDialer

    Copyright (C) 1998-1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <getopt.h>

#include "gmasqdialer.h"

gchar *masqhost;
gint masqport;
gboolean autoconnect;

gchar *username;
gchar *autorun;
gboolean autosenduser;

gchar *defaultisp;

gboolean lastone_hangup;
gboolean show_mainwin_at_start;
gboolean hide_mainwin_after_connect;
gboolean show_menubar;
gboolean beep_connects;
gboolean panel_show_input, panel_show_output, panel_show_label;

void setup_init(void)
{
    masqhost = g_strdup(gnome_config_get_string("/"PACKAGE"/host/addr=localhost"));
    masqport = gnome_config_get_int("/"PACKAGE"/host/port=222");
    autoconnect = gnome_config_get_bool("/"PACKAGE"/host/autoconnect=FALSE");
    username = g_strdup(gnome_config_get_string("/"PACKAGE"/host/user="));
    autorun = g_strdup(gnome_config_get_string("/"PACKAGE"/host/autorun="));
    autosenduser = gnome_config_get_bool("/"PACKAGE"/host/autosenduser=FALSE");
    lastone_hangup = gnome_config_get_bool("/"PACKAGE"/host/lasthangup=FALSE");
    show_mainwin_at_start = gnome_config_get_bool("/"PACKAGE"/host/showmainwin=TRUE");
    hide_mainwin_after_connect = gnome_config_get_bool("/"PACKAGE"/host/hidemainafterconnect=FALSE");
    show_menubar = gnome_config_get_bool("/"PACKAGE"/host/showmenubar=TRUE");
    beep_connects = gnome_config_get_bool("/"PACKAGE"/host/beepconnects=FALSE");

    panel_show_input = gnome_config_get_bool("/"PACKAGE"/host/panelinput=TRUE");
    panel_show_output = gnome_config_get_bool("/"PACKAGE"/host/paneloutput=TRUE");
    panel_show_label = gnome_config_get_bool("/"PACKAGE"/host/panellabel=TRUE");
    defaultisp = g_strdup(gnome_config_get_string("/"PACKAGE"/host/isp="));
}

static gint value_changed(GtkWidget *widget, GtkWidget *dialog)
{
    gnome_property_box_changed(GNOME_PROPERTY_BOX(dialog));
    return FALSE;
}

static void checkbox_clicked(GtkWidget *button, GtkWidget *dialog)
{
    gboolean flag;
    gchar *name;

    gnome_property_box_changed(GNOME_PROPERTY_BOX(dialog));
    name = gtk_object_get_data(GTK_OBJECT(button), "name");
    flag = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(dialog), name));
    gtk_object_set_data(GTK_OBJECT(dialog), name, GINT_TO_POINTER(!flag));
}

static void setup_apply(GtkWidget *dialog)
{
    GtkEntry *addrentry, *portentry, *userentry, *autorunentry;

    addrentry = gtk_object_get_data(GTK_OBJECT(dialog), "addr");
    portentry = gtk_object_get_data(GTK_OBJECT(dialog), "port");
    autoconnect = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(dialog), "autoconn"));
    autosenduser = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(dialog), "autosenduser"));
    lastone_hangup = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(dialog), "lasthangup"));
    userentry = gtk_object_get_data(GTK_OBJECT(dialog), "user");
    autorunentry = gtk_object_get_data(GTK_OBJECT(dialog), "autorun");

    show_mainwin_at_start = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(dialog), "showmainwin"));
    hide_mainwin_after_connect = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(dialog), "hidemainafterconnect"));
    show_menubar = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(dialog), "showmenubar"));
    beep_connects = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(dialog), "beepconnects"));
    panel_show_input = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(dialog), "panelinput"));
    panel_show_output = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(dialog), "paneloutput"));
    panel_show_label = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(dialog), "panellabel"));

    if (masqhost != NULL) g_free(masqhost);
    if (username != NULL) g_free(username);
    if (autorun != NULL) g_free(autorun);
    masqhost = g_strdup(gtk_entry_get_text(addrentry));
    username = g_strdup(gtk_entry_get_text(userentry));
    autorun = g_strdup(gtk_entry_get_text(autorunentry));
    if (sscanf(gtk_entry_get_text(portentry), "%d", &masqport) != 1)
        masqport = 222;

    gnome_config_set_string("/"PACKAGE"/host/addr", masqhost);
    gnome_config_set_string("/"PACKAGE"/host/user", username);
    gnome_config_set_string("/"PACKAGE"/host/autorun", autorun);
    gnome_config_set_int("/"PACKAGE"/host/port", masqport);
    gnome_config_set_bool("/"PACKAGE"/host/autoconnect", autoconnect);
    gnome_config_set_bool("/"PACKAGE"/host/autosenduser", autosenduser);
    gnome_config_set_bool("/"PACKAGE"/host/lasthangup", lastone_hangup);
    gnome_config_set_bool("/"PACKAGE"/host/showmainwin", show_mainwin_at_start);
    gnome_config_set_bool("/"PACKAGE"/host/hidemainafterconnect", hide_mainwin_after_connect);
    gnome_config_set_bool("/"PACKAGE"/host/showmenubar", show_menubar);
    gnome_config_set_bool("/"PACKAGE"/host/beepconnects", beep_connects);
    gnome_config_set_bool("/"PACKAGE"/host/panelinput", panel_show_input);
    gnome_config_set_bool("/"PACKAGE"/host/paneloutput", panel_show_output);
    gnome_config_set_bool("/"PACKAGE"/host/panellabel", panel_show_label);
    gnome_config_sync();
}

void create_checkbox(GtkWidget *dialog, GtkWidget *vbox, gchar *tag, gboolean flag, gchar *label)
{
    GtkWidget *button;

    button = gtk_check_button_new_with_label(label);
    gtk_object_set_data(GTK_OBJECT(button), "name", tag);
    gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), flag);
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
                       GTK_SIGNAL_FUNC(checkbox_clicked), dialog);
}

void menu_setup(void)
{
    GtkWidget *dialog, *vbox, *hbox;
    GtkWidget *addrentry, *portentry, *userentry, *autorunentry, *label;
    GString *str;

    dialog = gnome_property_box_new();

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_border_width(GTK_CONTAINER(vbox), 10);

    hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);

    label = gtk_label_new(_("Masqdialer server address: "));
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    addrentry = gtk_entry_new();
    if (masqhost != NULL) gtk_entry_set_text(GTK_ENTRY(addrentry), masqhost);
    gtk_box_pack_start(GTK_BOX(hbox), addrentry, TRUE, TRUE, 0);
    gtk_signal_connect (GTK_OBJECT (addrentry), "changed",
                        GTK_SIGNAL_FUNC (value_changed), dialog);

    hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);

    label = gtk_label_new(_("Masqdialer server port: "));
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    portentry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(hbox), portentry, TRUE, TRUE, 0);

    str = g_string_new(NULL);
    g_string_sprintf(str, "%d", masqport);
    gtk_entry_set_text(GTK_ENTRY(portentry), str->str);
    g_string_free(str, TRUE);

    gtk_signal_connect (GTK_OBJECT (portentry), "changed",
                        GTK_SIGNAL_FUNC (value_changed), dialog);

    hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);

    label = gtk_label_new(_("Default user name: "));
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    userentry = gtk_entry_new();
    if (username != NULL) gtk_entry_set_text(GTK_ENTRY(userentry), username);
    gtk_box_pack_start(GTK_BOX(hbox), userentry, TRUE, TRUE, 0);
    gtk_signal_connect (GTK_OBJECT (userentry), "changed",
                        GTK_SIGNAL_FUNC (value_changed), dialog);

    hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);

    label = gtk_label_new(_("Run command after connected: "));
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    autorunentry = gtk_entry_new();
    if (autorun != NULL) gtk_entry_set_text(GTK_ENTRY(autorunentry), autorun);
    gtk_box_pack_start(GTK_BOX(hbox), autorunentry, TRUE, TRUE, 0);
    gtk_signal_connect (GTK_OBJECT (autorunentry), "changed",
                        GTK_SIGNAL_FUNC (value_changed), dialog);

    create_checkbox(dialog, vbox, "autoconn", autoconnect, _("Autoconnect to server at startup: "));
    create_checkbox(dialog, vbox, "autosenduser", autosenduser, _("Send user information to server at startup: "));
    create_checkbox(dialog, vbox, "lasthangup", lastone_hangup, _("'Last client hangs up' is set on server: "));

    create_checkbox(dialog, vbox, "showmainwin", show_mainwin_at_start, _("If started as applet, show also main window"));
    create_checkbox(dialog, vbox, "hidemainafterconnect", hide_mainwin_after_connect, _("Hide main window after connected"));
    create_checkbox(dialog, vbox, "showmenubar", show_menubar, _("Show menubar"));
    create_checkbox(dialog, vbox, "beepconnects", beep_connects, _("Beep when connected/disconnected"));
    create_checkbox(dialog, vbox, "panellabel", panel_show_label, _("Show connection time in applet"));
    create_checkbox(dialog, vbox, "panelinput", panel_show_input, _("Show input load meter in applet"));
    create_checkbox(dialog, vbox, "paneloutput", panel_show_output, _("Show output load meter in applet"));

    gnome_property_box_append_page(GNOME_PROPERTY_BOX(dialog),
                                   vbox, gtk_label_new(_("Server")));

    gtk_object_set_data(GTK_OBJECT(dialog), "addr", addrentry);
    gtk_object_set_data(GTK_OBJECT(dialog), "port", portentry);
    gtk_object_set_data(GTK_OBJECT(dialog), "autoconn", GINT_TO_POINTER((gint) autoconnect));
    gtk_object_set_data(GTK_OBJECT(dialog), "user", userentry);
    gtk_object_set_data(GTK_OBJECT(dialog), "autorun", autorunentry);
    gtk_object_set_data(GTK_OBJECT(dialog), "autosenduser", GINT_TO_POINTER((gint) autosenduser));
    gtk_object_set_data(GTK_OBJECT(dialog), "lasthangup", GINT_TO_POINTER((gint) lastone_hangup));
    gtk_object_set_data(GTK_OBJECT(dialog), "showmainwin", GINT_TO_POINTER((gint) show_mainwin_at_start));
    gtk_object_set_data(GTK_OBJECT(dialog), "hidemainafterconnect", GINT_TO_POINTER((gint) hide_mainwin_after_connect));
    gtk_object_set_data(GTK_OBJECT(dialog), "showmenubar", GINT_TO_POINTER((gint) show_menubar));
    gtk_object_set_data(GTK_OBJECT(dialog), "beepconnects", GINT_TO_POINTER((gint) beep_connects));
    gtk_object_set_data(GTK_OBJECT(dialog), "panelinput", GINT_TO_POINTER((gint) panel_show_input));
    gtk_object_set_data(GTK_OBJECT(dialog), "paneloutput", GINT_TO_POINTER((gint) panel_show_output));
    gtk_object_set_data(GTK_OBJECT(dialog), "panellabel", GINT_TO_POINTER((gint) panel_show_label));

#ifdef HAVE_GNOME
    gtk_signal_connect(GTK_OBJECT(dialog), "apply",
                       GTK_SIGNAL_FUNC(setup_apply), dialog);
#else
    gnome_property_box_set_apply_func(dialog, (GtkFunction) setup_apply, dialog);
#endif

    gtk_widget_show_all(dialog);
}
