/**************************************************************************** 
** File: esp.c
**
** Author: Mike Borella
**
** Comments: Dump ESP header information. Since this packet sniffer
** is stateless, we cannot determine any headers besides the SPI and the
** sequence number.  In order to figure out the padding length and next 
** payload headers we would need to know the authentication mechanism 
** (if any) used for this SA.  But that info is part of the ISAKMP
** negotiation rather than the ESP header.  Oh well.
**
*****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include "config.h"
#include "esp.h"
#include "ah.h"
#include "ip.h" /* for header number dependencies - fix later */
#include "tcp.h"
#include "udp.h"
#include "icmp.h"

extern u_char *packet_end;

/*----------------------------------------------------------------------------
**
** dump_esp()
**
** Parse ESP packet and dump fields.
**
**----------------------------------------------------------------------------
*/

void dump_esp(u_char *bp, int length)
{
  u_char *ep = bp + length;
  ESPHdr *esp;

  /*
   * Make sure we don't run off the end of the packet
   */

  if (ep > packet_end) 
    ep = packet_end;

  esp = (ESPHdr *) bp;

  printf("-----------------------------------------------------------------\n");
  printf("                        ESP Header\n");
  printf("-----------------------------------------------------------------\n");
  
  printf("SPI:                    %d\n", ntohl(esp->spi));
  printf("Sequence number:        %d\n", ntohl(esp->seqno));

}

