#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>

#include "countrycodes.h"

const struct SCountry gCountries[NUM_COUNTRIES + 1] =
{
  { "Afghanistan", 93, 0 },
  { "Albania", 355, 1 },
  { "Algeria", 213, 2 },
  { "American Samoa", 684, 3 },
  { "Andorra", 376, 4 },
  { "Angola", 244, 5 },
  { "Anguilla", 101, 6 },
  { "Antigua", 102, 7 },
  { "Argentina", 54, 8 },
  { "Armenia", 374, 9 },
  { "Aruba", 297, 10 },
  { "Ascension Island", 247, 11 },
  { "Australia", 61, 12 },
  { "Australian Antarctic Territory", 6721, 13 },
  { "Austria", 43, 14 },
  { "Azerbaijan", 994, 15 },
  { "Bahamas", 103, 16 },
  { "Bahrain", 973, 17 },
  { "Bangladesh", 880, 18 },
  { "Barbados", 104, 19 },
  { "Barbuda", 120, 20 },
  { "Belarus", 375, 21 },
  { "Belgium", 32, 22 },
  { "Belize", 501, 23 },
  { "Benin", 229, 24 },
  { "Bermuda", 105, 25 },
  { "Bhutan", 975, 26 },
  { "Bolivia", 591, 27 },
  { "Bosnia and Herzegovina", 387, 28 },
  { "Botswana", 267, 29 },
  { "Brazil", 55, 30 },
  { "British Virgin Islands", 106, 31 },
  { "Brunei", 673, 32 },
  { "Bulgaria", 359, 33 },
  { "Burkina Faso", 226, 34 },
  { "Burundi", 257, 35 },
  { "Cambodia", 855, 36 },
  { "Cameroon", 237, 37 },
  { "Canada", 107, 38 },
  { "Cape Verde Islands", 238, 39 },
  { "Cayman Islands", 108, 40 },
  { "Central African Republic", 236, 41 },
  { "Chad", 235, 42 },
  { "Chile", 56, 43 },
  { "China", 86, 44 },
  { "Christmas Island", 672, 45 },
  { "Cocos-Keeling Islands", 6101, 46 },
  { "Columbia", 57, 47 },
  { "Comoros", 2691, 48 },
  { "Congo", 242, 49 },
  { "Cook Islands", 682, 50 },
  { "Costa Rica", 506, 51 },
  { "Croatia", 385, 52 },
  { "Cuba", 53, 53 },
  { "Cyprus", 357, 54 },
  { "Czech Republic", 42, 55 },
  { "Denmark", 45, 56 },
  { "Diego Garcia", 246, 57 },
  { "Djibouti", 253, 58 },
  { "Dominica", 109, 59 },
  { "Dominican Republic", 110, 60 },
  { "Ecuador", 593, 61 },
  { "Egypt", 20, 62 },
  { "El Salvador", 503, 63 },
  { "Equatorial Guinea", 240, 64 },
  { "Eritrea", 291, 65 },
  { "Estonia", 372, 66 },
  { "Ethiopia", 251, 67 },
  { "Faeroe Islands", 298, 68 },
  { "Falkland Islands", 500, 69 },
  { "Fiji Islands", 679, 70 },
  { "Finland", 358, 71 },
  { "France", 33, 72 },
  { "French Antilles", 5901, 73 },
  { "French Guiana", 594, 74 },
  { "French Polynesia", 689, 75 },
  { "Gabon", 241, 76 },
  { "Gambia", 220, 77 },
  { "Georgia", 995, 78 },
  { "Germany", 49, 79 },
  { "Ghana", 233, 80 },
  { "Gibraltar", 350, 81 },
  { "Greece", 30, 82 },
  { "Greenland", 299, 83 },
  { "Grenada", 111, 84 },
  { "Guadeloupe", 590, 85 },
  { "Guam", 671, 86 },
  { "Guantanamo Bay", 5399, 87 },
  { "Guatemala", 502, 88 },
  { "Guinea", 224, 89 },
  { "Guinea-Bissau", 245, 90 },
  { "Guyana", 592, 91 },
  { "Haiti", 509, 92 },
  { "Honduras", 504, 93 },
  { "Hong Kong", 852, 94 },
  { "Hungary", 36, 95 },
  { "INMARSAT (Atlantic-East)", 871, 96 },
  { "INMARSAT (Atlantic-West)", 874, 97 },
  { "INMARSAT (Indian)", 873, 98 },
  { "INMARSAT (Pacific)", 872, 99 },
  { "INMARSAT", 870, 100 },
  { "Iceland", 354, 101 },
  { "India", 91, 102 },
  { "Indonesia", 62, 103 },
  { "International Freephone Service", 800, 104 },
  { "Iran", 98, 105 },
  { "Iraq", 964, 106 },
  { "Ireland", 353, 107 },
  { "Israel", 972, 108 },
  { "Italy", 39, 109 },
  { "Ivory Coast", 225, 110 },
  { "Jamaica", 112, 111 },
  { "Japan", 81, 112 },
  { "Jordan", 962, 113 },
  { "Kazakhstan", 705, 114 },
  { "Kenya", 254, 115 },
  { "Kiribati Republic", 686, 116 },
  { "Korea (North)", 850, 117 },
  { "Korea (Republic of)", 82, 118 },
  { "Kuwait", 965, 119 },
  { "Kyrgyz Republic", 706, 120 },
  { "Laos", 856, 121 },
  { "Latvia", 371, 122 },
  { "Lebanon", 961, 123 },
  { "Lesotho", 266, 124 },
  { "Liberia", 231, 125 },
  { "Libya", 218, 126 },
  { "Liechtenstein", 4101, 127 },
  { "Lithuania", 370, 128 },
  { "Luxembourg", 352, 129 },
  { "Macau", 853, 130 },
  { "Madagascar", 261, 131 },
  { "Malawi", 265, 132 },
  { "Malaysia", 60, 133 },
  { "Maldives", 960, 134 },
  { "Mali", 223, 135 },
  { "Malta", 356, 136 },
  { "Marshall Islands", 692, 137 },
  { "Martinique", 596, 138 },
  { "Mauritania", 222, 139 },
  { "Mauritius", 230, 140 },
  { "Mayotte Island", 269, 141 },
  { "Mexico", 52, 142 },
  { "Micronesia, Federated States of", 691, 143 },
  { "Moldova", 373, 144 },
  { "Monaco", 377, 145 },
  { "Mongolia", 976, 146 },
  { "Montserrat", 113, 147 },
  { "Morocco", 212, 148 },
  { "Mozambique", 258, 149 },
  { "Myanmar", 95, 150 },
  { "Namibia", 264, 151 },
  { "Nauru", 674, 152 },
  { "Nepal", 977, 153 },
  { "Netherlands Antilles", 599, 154 },
  { "Netherlands", 31, 155 },
  { "Nevis", 114, 156 },
  { "New Caledonia", 687, 157 },
  { "New Zealand", 64, 158 },
  { "Nicaragua", 505, 159 },
  { "Niger", 227, 160 },
  { "Nigeria", 234, 161 },
  { "Niue", 683, 162 },
  { "Norfolk Island", 6722, 163 },
  { "Norway", 47, 164 },
  { "Oman", 968, 165 },
  { "Pakistan", 92, 166 },
  { "Palau", 680, 167 },
  { "Panama", 507, 168 },
  { "Papua New Guinea", 675, 169 },
  { "Paraguay", 595, 170 },
  { "Peru", 51, 171 },
  { "Philippines", 63, 172 },
  { "Poland", 48, 173 },
  { "Portugal", 351, 174 },
  { "Puerto Rico", 121, 175 },
  { "Qatar", 974, 176 },
  { "Republic of Macedonia", 389, 177 },
//  { "Former Yugoslav Republic of Macedonia", 389, 177 },
  { "Reunion Island", 262, 178 },
  { "Romania", 40, 179 },
  { "Rota Island", 6701, 180 },
  { "Russia", 7, 181 },
  { "Rwanda", 250, 182 },
  { "Saint Lucia", 122, 183 },
  { "Saipan Island", 670, 184 },
  { "San Marino", 378, 185 },
  { "Sao Tome and Principe", 239, 186 },
  { "Saudi Arabia", 966, 187 },
  { "Senegal Republic", 221, 188 },
  { "Seychelle Islands", 248, 189 },
  { "Sierra Leone", 232, 190 },
  { "Singapore", 65, 191 },
  { "Slovak Republic", 4201, 192 },
  { "Slovenia", 386, 193 },
  { "Solomon Islands", 677, 194 },
  { "Somalia", 252, 195 },
  { "South Africa", 27, 196 },
  { "Spain", 34, 197 },
  { "Sri Lanka", 94, 198 },
  { "St. Helena", 290, 199 },
  { "St. Kitts", 115, 200 },
  { "St. Pierre and Miquelon", 508, 201 },
  { "St. Vincent and the Grenadines", 116, 202 },
  { "Sudan", 249, 203 },
  { "Suriname", 597, 204 },
  { "Swaziland", 268, 205 },
  { "Sweden", 46, 206 },
  { "Switzerland", 41, 207 },
  { "Syria", 963, 208 },
  { "Taiwan, Republic of China", 886, 209 },
  { "Tajikistan", 708, 210 },
  { "Tanzania", 255, 211 },
  { "Thailand", 66, 212 },
  { "Tinian Island", 6702, 213 },
  { "Togo", 228, 214 },
  { "Tokelau", 690, 215 },
  { "Tonga", 676, 216 },
  { "Trinidad and Tobago", 117, 217 },
  { "Tunisia", 216, 218 },
  { "Turkey", 90, 219 },
  { "Turkmenistan", 709, 220 },
  { "Turks and Caicos Islands", 118, 221 },
  { "Tuvalu", 688, 222 },
  { "USA", 1, 223 },
  { "Uganda", 256, 224 },
  { "Ukraine", 380, 225 },
  { "United Arab Emirates", 971, 226 },
  { "United Kingdom", 44, 227 },
  { "United States Virgin Islands", 123, 228 },
  { "Uruguay", 598, 229 },
  { "Uzbekistan", 711, 230 },
  { "Vanuatu", 678, 231 },
  { "Vatican City", 379, 232 },
  { "Venezuela", 58, 233 },
  { "Vietnam", 84, 234 },
  { "Wallis and Futuna Islands", 681, 235 },
  { "Western Samoa", 685, 236 },
  { "Yemen", 967, 237 },
  { "Yugoslavia", 381, 238 },
  { "Zaire", 243, 239 },
  { "Zambia", 260, 240 },
  { "Zimbabwe", 263, 241 },
  { "Unspecified", COUNTRY_UNSPECIFIED, 242 }
};


const struct SCountry *GetCountryByCode(unsigned short _nCountryCode)
{
   // do a simple linear search as there aren't too many countries
   unsigned short i = 0;
   while (i < NUM_COUNTRIES && gCountries[i].nCode != _nCountryCode) i++;
   if (i == NUM_COUNTRIES) return NULL;
   return &gCountries[i];
}

const struct SCountry *GetCountryByIndex(unsigned short _nIndex)
{
   if (_nIndex >= NUM_COUNTRIES) return NULL;
   return (&gCountries[_nIndex]);
}

